/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.saved_data;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MemoryTabletData
extends SavedData {
    private boolean hasLinkedObelisk = false;
    private BlockPos linkedObelisk = new BlockPos(0, 0, 0);
    private String dimension = "minecraft:overworld";
    private long experienceToRecover = 0L;

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("HasLinkedObelisk", this.hasLinkedObelisk);
        tag.m_128385_("LinkedObelisk", new int[]{this.linkedObelisk.m_123341_(), this.linkedObelisk.m_123342_(), this.linkedObelisk.m_123343_()});
        tag.m_128359_("Dimension", this.dimension);
        tag.m_128356_("ExperienceToRecover", this.experienceToRecover);
        return tag;
    }

    public MemoryTabletData load(CompoundTag tag) {
        this.hasLinkedObelisk = tag.m_128471_("HasLinkedObelisk");
        int[] pos = tag.m_128465_("LinkedObelisk");
        this.linkedObelisk = new BlockPos(pos[0], pos[1], pos[2]);
        this.dimension = tag.m_128461_("Dimension");
        this.experienceToRecover = tag.m_128454_("ExperienceToRecover");
        return this;
    }

    public static MemoryTabletData loadStatic(CompoundTag tag) {
        MemoryTabletData data = new MemoryTabletData();
        return data.load(tag);
    }

    public void setLinkedObelisk(BlockPos pos, String dimension, boolean hasLinkedObelisk) {
        this.linkedObelisk = pos;
        this.dimension = dimension;
        this.hasLinkedObelisk = hasLinkedObelisk;
        this.m_77762_();
    }

    public boolean hasLinkedObelisk() {
        return this.hasLinkedObelisk;
    }

    public BlockPos getLinkedObelisk() {
        return this.linkedObelisk;
    }

    public String getDimension() {
        return this.dimension;
    }

    public boolean dimensionMatches(Level level) {
        return level.m_46472_().m_135782_().toString().equals(this.dimension);
    }

    public void setExperienceToRecover(long points) {
        this.experienceToRecover = points;
        this.m_77762_();
    }

    public long getExperienceToRecover() {
        return this.experienceToRecover;
    }

    @Nullable
    public static MemoryTabletData getFromStorage(Level level, String uuid) {
        if (level.m_7654_() != null) {
            DimensionDataStorage overworldStorage = level.m_7654_().m_129783_().m_8895_();
            return (MemoryTabletData)overworldStorage.m_164858_(MemoryTabletData::loadStatic, "memory_tablet_data_of_" + uuid);
        }
        return null;
    }

    @Nullable
    public static MemoryTabletData getFromStorage(Player player) {
        return MemoryTabletData.getFromStorage(player.m_9236_(), player.m_20149_());
    }

    public static void createAndSaveToStorage(Level level, String uuid, MemoryTabletData data) {
        if (level.m_7654_() != null) {
            DimensionDataStorage overworldStorage = level.m_7654_().m_129783_().m_8895_();
            overworldStorage.m_164861_(MemoryTabletData::loadStatic, () -> data, "memory_tablet_data_of_" + uuid);
            overworldStorage.m_78151_();
        }
    }

    public static void createAndSaveToStorage(Player player, MemoryTabletData data) {
        MemoryTabletData.createAndSaveToStorage(player.m_9236_(), player.m_20149_(), data);
    }

    public String toString() {
        return "[Memory Tablet Data] \nHasLinkedObelisk: " + this.hasLinkedObelisk + "\nLinkedObelisk: " + this.linkedObelisk.m_123344_() + "\nDimension: " + this.dimension + "\nExperienceToRecover: " + this.experienceToRecover;
    }
}

