/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.gui.ExperienceObeliskMenu;
import com.cyanogen.cognition.registries.RegisterAttachments;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceObeliskBlock
extends Block
implements EntityBlock {
    public ItemStack stack;

    public ExperienceObeliskBlock() {
        super(BlockBehaviour.Properties.of().strength(9.0f).destroyTime(1.2f).explosionResistance(9.0f).noOcclusion().lightLevel(value -> 7).sound(SoundType.METAL).requiresCorrectToolForDrops());
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape1 = Shapes.create((AABB)new AABB(0.41875, 0.875, 0.41875, 0.58125, 0.96875, 0.58125));
        VoxelShape shape2 = Shapes.create((AABB)new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.26875, 0.9375));
        VoxelShape shape3 = Shapes.create((AABB)new AABB(0.3125, 0.25, 0.3125, 0.6875, 0.3125, 0.6875));
        return Shapes.join((VoxelShape)Shapes.join((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.OR), (VoxelShape)shape3, (BooleanOp)BooleanOp.OR).optimize();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            ExperienceObeliskEntity obelisk;
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof ExperienceObeliskEntity && (obelisk = (ExperienceObeliskEntity)entity).hasBeenMemorized(player)) {
                player.removeData(RegisterAttachments.MEMORY_TABLET_OBELISK_LOCATION);
                player.removeData(RegisterAttachments.PLAYER_EXPERIENCE_PROGRESS_ON_DEATH);
                player.removeData(RegisterAttachments.PLAYER_EXPERIENCE_LEVELS_ON_DEATH);
            }
            if (player.hasCorrectToolForDrops(state, level, pos) && entity != null) {
                this.stack = new ItemStack((ItemLike)state.getBlock(), 1);
                entity.saveToItem(this.stack, (HolderLookup.Provider)level.registryAccess());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BlockEntity entity;
        if (!level.isClientSide && (entity = level.getBlockEntity(pos)) != null) {
            this.stack = new ItemStack((ItemLike)state.getBlock(), 1);
            entity.saveToItem(this.stack, (HolderLookup.Provider)level.registryAccess());
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.stack != null) {
            drops.add(this.stack);
            return drops;
        }
        return super.getDrops(state, params);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        player.openMenu(this.getMenuProvider(state, level, pos), pos);
        return ItemInteractionResult.CONSUME;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        player.openMenu(this.getMenuProvider(state, level, pos), pos);
        return InteractionResult.CONSUME;
    }

    @NotNull
    public MenuProvider getMenuProvider(BlockState state, Level level, final BlockPos pos) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Experience Obelisk");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                return new ExperienceObeliskMenu(id, inventory, pos);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.EXPERIENCE_OBELISK.get() ? ExperienceObeliskEntity::tick : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.EXPERIENCE_OBELISK.get()).create(pos, state);
    }
}

