/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.block.AcceleratorBlock;
import com.cyanogen.cognition.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AcceleratorEntity
extends AbstractAcceleratorEntity {
    static double orbSpeed = 2.0;
    static double entitySpeed = 1.3;

    public AcceleratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.ACCELERATOR.get(), pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AcceleratorEntity) {
            AcceleratorEntity accelerator = (AcceleratorEntity)((Object)blockEntity);
            if (!accelerator.redstoneEnabled || level.hasNeighborSignal(pos)) {
                if (!((Boolean)state.getValue((Property)AcceleratorBlock.ACTIVE)).booleanValue()) {
                    state = (BlockState)state.setValue((Property)AcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                    level.setBlockAndUpdate(pos, state);
                }
                Direction facing = (Direction)state.getValue((Property)AcceleratorBlock.FACING);
                int x = 0;
                int y = 0;
                int z = 0;
                switch (facing) {
                    case UP: {
                        y = 1;
                        break;
                    }
                    case DOWN: {
                        y = -1;
                        break;
                    }
                    case NORTH: {
                        z = -1;
                        break;
                    }
                    case SOUTH: {
                        z = 1;
                        break;
                    }
                    case EAST: {
                        x = 1;
                        break;
                    }
                    case WEST: {
                        x = -1;
                    }
                }
                AABB area = new AABB((double)(pos.getX() + x), (double)(pos.getY() + y), (double)(pos.getZ() + z), (double)(pos.getX() + 1 + x), (double)(pos.getY() + 1 + y), (double)(pos.getZ() + 1 + z));
                List list = level.getEntities(null, area);
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        Player player;
                        boolean isShiftPlayer;
                        boolean bl = isShiftPlayer = entity instanceof Player && (player = (Player)entity).isShiftKeyDown();
                        if (entity instanceof ExperienceOrb) {
                            ExperienceOrb orb = (ExperienceOrb)entity;
                            orb.addDeltaMovement(new Vec3(orbSpeed * (double)x, orbSpeed * (double)y, orbSpeed * (double)z));
                            continue;
                        }
                        if (isShiftPlayer) continue;
                        double yVelocity = entity.getDeltaMovement().y();
                        entity.addDeltaMovement(new Vec3(entitySpeed * (double)x, entitySpeed * (double)y - yVelocity, entitySpeed * (double)z));
                    }
                }
            } else if (((Boolean)state.getValue((Property)AcceleratorBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)AcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.setBlockAndUpdate(pos, state);
            }
        }
    }
}

