/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.block_entities.ExperienceReceivingEntity;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExperienceFountainEntity
extends ExperienceReceivingEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation ACTIVE_SLOW = RawAnimation.begin().thenPlay("active-slow");
    protected static final RawAnimation ACTIVE_MODERATE = RawAnimation.begin().thenPlay("active-moderate");
    protected static final RawAnimation ACTIVE_FAST = RawAnimation.begin().thenPlay("active-fast");
    protected static final RawAnimation ACTIVE_HYPER = RawAnimation.begin().thenPlay("active-hyperspeed");
    protected static final RawAnimation SLOW = RawAnimation.begin().thenPlay("slow");
    protected static final RawAnimation MODERATE = RawAnimation.begin().thenPlay("moderate");
    protected static final RawAnimation FAST = RawAnimation.begin().thenPlay("fast");
    protected static final RawAnimation HYPER = RawAnimation.begin().thenPlay("hyperspeed");
    public static final Component customName = Component.literal((String)"SpawnedFromFountain");
    private int activityState = 0;
    public boolean hasPlayerAbove = false;

    public ExperienceFountainEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.EXPERIENCE_FOUNTAIN.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, this::controller));
    }

    protected <E extends ExperienceFountainEntity> PlayState controller(AnimationState<E> state) {
        BlockEntity entity = (BlockEntity)state.getAnimatable();
        AnimationController controller = state.getController();
        RawAnimation animation = controller.getCurrentRawAnimation();
        RawAnimation animationToPlay = SLOW;
        if (this.level != null && entity instanceof ExperienceFountainEntity) {
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)entity;
            boolean hasNeighborSignal = this.level.hasNeighborSignal(fountain.getBlockPos());
            boolean isActive = fountain.isBound() && (hasNeighborSignal || fountain.hasPlayerAbove);
            switch (fountain.activityState) {
                case 0: {
                    if (!isActive) break;
                    animationToPlay = ACTIVE_SLOW;
                    break;
                }
                case 1: {
                    if (isActive) {
                        animationToPlay = ACTIVE_MODERATE;
                        break;
                    }
                    animationToPlay = MODERATE;
                    break;
                }
                case 2: {
                    if (isActive) {
                        animationToPlay = ACTIVE_FAST;
                        break;
                    }
                    animationToPlay = FAST;
                    break;
                }
                case 3: {
                    animationToPlay = isActive ? ACTIVE_HYPER : HYPER;
                }
            }
        }
        if (animation == null || !animation.equals((Object)animationToPlay)) {
            controller.setAnimation(animationToPlay);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        ExperienceFountainEntity fountain;
        if (blockEntity instanceof ExperienceFountainEntity && (fountain = (ExperienceFountainEntity)((Object)blockEntity)).isBound()) {
            int z;
            int y;
            ExperienceObeliskEntity obelisk = fountain.getBoundObelisk();
            int x = pos.getX();
            List playerList = level.getEntitiesOfClass(Player.class, new AABB((double)x + 0.25, (double)(y = pos.getY()) + 0.5, (double)(z = pos.getZ()) + 0.25, (double)x + 0.75, (double)y + 1.065, (double)z + 0.75));
            if (!playerList.isEmpty() && !fountain.hasPlayerAbove) {
                level.playSound(null, pos, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS, 0.2f, 0.6f);
                fountain.hasPlayerAbove = true;
                level.sendBlockUpdated(pos, state, state, 2);
            } else if (playerList.isEmpty() && fountain.hasPlayerAbove) {
                level.playSound(null, pos, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF, SoundSource.BLOCKS, 0.2f, 0.2f);
                fountain.hasPlayerAbove = false;
                level.sendBlockUpdated(pos, state, state, 2);
            }
            if (obelisk != null && !level.isClientSide && obelisk.getFluidAmount() > 0 && (level.hasNeighborSignal(pos) || fountain.hasPlayerAbove)) {
                int value = 4;
                int interval = 20;
                switch (fountain.getActivityState()) {
                    case 1: {
                        value = 20;
                        interval = 10;
                        break;
                    }
                    case 2: {
                        value = 100;
                        interval = 5;
                        break;
                    }
                    case 3: {
                        value = 400;
                        interval = 2;
                    }
                }
                if (value > obelisk.getFluidAmount() / 20) {
                    value = obelisk.getFluidAmount() / 20;
                }
                if (level.getGameTime() % (long)interval == 0L) {
                    ServerLevel server = (ServerLevel)level;
                    ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, value);
                    orb.setCustomName(customName);
                    orb.setCustomNameVisible(false);
                    obelisk.drain(value * 20);
                    orb.setDeltaMovement(0.0, 0.25, 0.0);
                    server.addFreshEntity((Entity)orb);
                }
            }
        }
    }

    public int getActivityState() {
        return this.activityState;
    }

    public void cycleActivityState() {
        ++this.activityState;
        if (this.activityState > 3) {
            this.activityState = 0;
        }
        this.setChanged();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.activityState = tag.getInt("ActivityState");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("ActivityState", this.activityState);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.activityState = tag.getInt("ActivityState");
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("ActivityState", this.activityState);
        return tag;
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        CompoundTag tag = pkt.getTag();
        this.activityState = tag.getInt("ActivityState");
        this.hasPlayerAbove = tag.getBoolean("PlayerAbove");
        super.onDataPacket(net, pkt, provider);
    }
}

