/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.block_entities.ExperienceReceivingEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.registries.RegisterRecipes;
import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.RecipeUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MolecularMetamorpherEntity
extends ExperienceReceivingEntity
implements GeoBlockEntity {
    boolean isProcessing = false;
    boolean busy = false;
    int processTime = 0;
    int processProgress = 0;
    int recipeCost = 0;
    ResourceLocation recipeId;
    private boolean lockInputs = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation ACTIVE = RawAnimation.begin().thenPlay("active");
    public static final BlockCapability<IItemHandler, Direction> ITEM_HANDLER = Capabilities.ItemHandler.BLOCK;
    protected ItemStackHandler inputHandler = this.inputHandler();
    protected ItemStackHandler outputHandler = this.outputHandler();
    protected ItemStackHandler savedInputs = this.savedInputs();

    public MolecularMetamorpherEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.MOLECULAR_METAMORPHER.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, this::controller));
    }

    protected <E extends MolecularMetamorpherEntity> PlayState controller(AnimationState<E> state) {
        MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)state.getAnimatable();
        AnimationController controller = state.getController();
        RawAnimation animation = controller.getCurrentRawAnimation();
        if (animation == null) {
            controller.setAnimation(IDLE);
        } else if (metamorpher.busy && animation.equals((Object)IDLE)) {
            controller.setAnimation(ACTIVE);
        } else if (!metamorpher.busy && animation.equals((Object)ACTIVE)) {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof MolecularMetamorpherEntity) {
            boolean active;
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)((Object)blockEntity);
            boolean bl = active = !metamorpher.redstoneEnabled || level.hasNeighborSignal(pos);
            if (metamorpher.isProcessing) {
                metamorpher.busy = true;
                if (metamorpher.processProgress >= metamorpher.processTime) {
                    metamorpher.dispenseResult();
                } else if (metamorpher.validateRecipe()) {
                    metamorpher.incrementProcessProgress();
                }
            } else {
                metamorpher.busy = active && metamorpher.hasContents() ? (metamorpher.handleJsonRecipes() ? true : metamorpher.handleNameFormattingRecipes()) : false;
            }
            if (metamorpher.busy) {
                metamorpher.handleAudio(level, pos);
            }
        }
    }

    public boolean hasContents() {
        boolean hasContents = false;
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.inputHandler.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem().equals(Items.AIR)) continue;
            hasContents = true;
            break;
        }
        return hasContents;
    }

    public void handleAudio(Level level, BlockPos pos) {
        int period = 15;
        long time = level.getGameTime();
        if (time % (long)period == 0L) {
            level.playSound(null, pos, (SoundEvent)RegisterSounds.METAMORPHER_BUSY1.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        } else if (time % (long)period == (long)(period / 2)) {
            level.playSound(null, pos, (SoundEvent)RegisterSounds.METAMORPHER_BUSY2.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }

    @Nullable
    public static IItemHandler getCapability(MolecularMetamorpherEntity metamorpher, Direction direction) {
        if (direction == null || direction.equals((Object)Direction.UP)) {
            return null;
        }
        return direction.equals((Object)Direction.DOWN) ? metamorpher.outputHandler : metamorpher.inputHandler;
    }

    public ItemStackHandler inputHandler() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, ItemStack input) {
                ItemStack saved = MolecularMetamorpherEntity.this.savedInputs.getStackInSlot(slot);
                if (MolecularMetamorpherEntity.this.lockInputs && !saved.isEmpty()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)saved);
                }
                return super.isItemValid(slot, input);
            }

            protected void onContentsChanged(int slot) {
                MolecularMetamorpherEntity.this.setChanged();
                super.onContentsChanged(slot);
            }
        };
    }

    public ItemStackHandler outputHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }

            protected void onContentsChanged(int slot) {
                MolecularMetamorpherEntity.this.setChanged();
                super.onContentsChanged(slot);
            }
        };
    }

    public ItemStackHandler savedInputs() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }

            protected void onContentsChanged(int slot) {
                MolecularMetamorpherEntity.this.setChanged();
                super.onContentsChanged(slot);
            }
        };
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ItemStackHandler getSavedInputs() {
        return this.savedInputs;
    }

    public boolean isEmpty() {
        return this.inputsAreEmpty() && this.outputHandler.getStackInSlot(0).isEmpty();
    }

    public boolean inputsAreEmpty() {
        return this.inputHandler.getStackInSlot(0).isEmpty() && this.inputHandler.getStackInSlot(1).isEmpty() && this.inputHandler.getStackInSlot(2).isEmpty();
    }

    public boolean inputsAreLocked() {
        return this.lockInputs;
    }

    public void lockInputs(boolean lock) {
        this.lockInputs = lock;
        for (int i = 0; i < 3; ++i) {
            if (lock) {
                this.savedInputs.setStackInSlot(i, this.inputHandler.getStackInSlot(i).copy());
                continue;
            }
            this.savedInputs.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        this.setChanged();
    }

    public boolean handleJsonRecipes() {
        int cost;
        MolecularMetamorpherRecipe recipe;
        ItemStack output;
        if (this.getRecipe() != null && this.canPerformRecipe(output = (recipe = this.getRecipe()).assemble(this.getRecipeInput(), (HolderLookup.Provider)(this.level == null ? null : this.level.registryAccess())), cost = recipe.getCost())) {
            this.initiateRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean canPerformRecipe(ItemStack output, int cost) {
        ItemStack stackInResults = this.outputHandler.getStackInSlot(0);
        return this.getBoundObelisk() != null && this.getBoundObelisk().getFluidAmount() >= cost * 20 && (ItemStack.isSameItemSameComponents((ItemStack)stackInResults, (ItemStack)output) || stackInResults.isEmpty() || stackInResults.is(Items.AIR)) && stackInResults.getCount() <= output.getMaxStackSize() - output.getCount();
    }

    public void initiateRecipe(MolecularMetamorpherRecipe recipe) {
        this.setProcessing(true);
        this.setRecipeId(recipe);
        this.setProcessProgress(0);
        this.setProcessTime(recipe.getProcessTime());
        this.setRecipeCost(recipe.getCost());
        assert (this.getBoundObelisk() != null);
        this.getBoundObelisk().drain(recipe.getCost() * 20);
    }

    public boolean validateRecipe() {
        boolean hasValidJsonRecipe;
        boolean bl = hasValidJsonRecipe = this.getRecipe() != null && this.getRecipe().getId().equals((Object)this.recipeId);
        if (hasValidJsonRecipe || this.hasNameFormattingRecipe()) {
            return true;
        }
        if (this.getBoundObelisk() != null) {
            this.getBoundObelisk().fill(20 * this.recipeCost);
        }
        this.setProcessing(false);
        this.resetAll();
        return false;
    }

    public SimpleContainer deplete(MolecularMetamorpherRecipe recipe) {
        SimpleContainer container = new SimpleContainer(3);
        for (int k = 0; k < 3; ++k) {
            container.setItem(k, this.inputHandler.getStackInSlot(k).copy());
        }
        block1: for (int j = 1; j <= 3; ++j) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients(true).get(j).getA();
            int count = (Integer)recipe.getIngredients(true).get(j).getB();
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = container.getItem(i);
                if (!ingredient.test(stack)) continue;
                if (stack.is((Item)RegisterItems.TRANSFORMING_FOCUS.get())) {
                    if (stack.getDamageValue() >= 511) {
                        stack.shrink(1);
                        continue block1;
                    }
                    int damage = stack.getDamageValue();
                    stack.setDamageValue(damage + 1);
                    continue block1;
                }
                if (stack.hasCraftingRemainingItem()) {
                    container.setItem(i, stack.getCraftingRemainingItem());
                    continue block1;
                }
                if (stack.getCount() >= count) {
                    stack.shrink(count);
                    continue block1;
                }
                count -= stack.getCount();
                stack.shrink(stack.getCount());
            }
        }
        return container;
    }

    public void dispenseResult() {
        MolecularMetamorpherRecipe recipe = null;
        List list = this.level.getRecipeManager().getAllRecipesFor((RecipeType)RegisterRecipes.MOLECULAR_METAMORPHER_TYPE.get());
        for (RecipeHolder holder : list) {
            if (!((MolecularMetamorpherRecipe)holder.value()).getId().equals((Object)this.recipeId)) continue;
            recipe = (MolecularMetamorpherRecipe)holder.value();
        }
        if (recipe != null) {
            this.setProcessing(false);
            SimpleContainer resultState = this.deplete(recipe);
            ItemStack resultItem = recipe.getResultItem(null);
            ItemStack stackInResults = this.outputHandler.getStackInSlot(0).copy();
            int count = resultItem.getCount();
            if (ItemStack.isSameItemSameComponents((ItemStack)resultItem, (ItemStack)stackInResults)) {
                stackInResults.grow(count);
                this.outputHandler.setStackInSlot(0, stackInResults);
            } else {
                this.outputHandler.setStackInSlot(0, resultItem);
            }
            for (int i = 0; i < 3; ++i) {
                this.inputHandler.setStackInSlot(i, resultState.getItem(i));
            }
        }
        this.resetAll();
    }

    public boolean handleNameFormattingRecipes() {
        int cost;
        MolecularMetamorpherRecipe recipe;
        ItemStack output;
        if (((Boolean)Config.COMMON.formatting.get()).booleanValue() && this.hasNameFormattingRecipe() && this.canPerformRecipe(output = (recipe = this.getNameFormattingRecipe()).getResultItem(null), cost = recipe.getCost())) {
            this.initiateRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean hasNameFormattingRecipe() {
        Item formatItem = this.inputHandler.getStackInSlot(2).getItem();
        return !this.inputHandler.getStackInSlot(0).isEmpty() && this.inputHandler.getStackInSlot(1).is(Items.NAME_TAG) && (formatItem instanceof DyeItem || RecipeUtils.getValidFormattingItems().contains(formatItem));
    }

    public MolecularMetamorpherRecipe getNameFormattingRecipe() {
        int index;
        char code;
        ChatFormatting format;
        ItemStack inputItem = this.inputHandler.getStackInSlot(0);
        ItemStack nameTag = this.inputHandler.getStackInSlot(1);
        ItemStack formatStack = this.inputHandler.getStackInSlot(2);
        Item formatItem = formatStack.getItem();
        MutableComponent name = inputItem.getHoverName().copy();
        if (RecipeUtils.getValidDyes().contains(formatItem)) {
            DyeItem dye = (DyeItem)formatItem;
            int dyeColor = dye.getDyeColor().getId();
            format = ChatFormatting.getById((int)RecipeUtils.dyeColorToTextColor(dyeColor));
            if (format != null) {
                name = name.withStyle(format);
            }
        } else if (RecipeUtils.getValidFormattingItems().contains(formatItem) && (format = ChatFormatting.getByCode((char)(code = RecipeUtils.itemToFormat(index = RecipeUtils.getValidFormattingItems().indexOf(formatItem))))) != null) {
            name = name.withStyle(format);
        }
        Ingredient ingredient1 = Ingredient.of((ItemStack[])new ItemStack[]{inputItem.copy()});
        int count1 = inputItem.getCount();
        Ingredient ingredient2 = Ingredient.of((ItemStack[])new ItemStack[]{nameTag.copy()});
        int count2 = nameTag.getCount();
        Ingredient ingredient3 = Ingredient.of((ItemStack[])new ItemStack[]{formatStack.copy()});
        int count3 = formatStack.getCount();
        ItemStack output = inputItem.copy();
        output.set(DataComponents.ITEM_NAME, (Object)name);
        int cost = 315;
        int processTime = 60;
        return new MolecularMetamorpherRecipe(ingredient1, count1, ingredient2, count2, ingredient3, count3, output, cost, processTime, ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"item_name_formatting"));
    }

    @Nullable
    public MolecularMetamorpherRecipe getRecipe() {
        Optional holder = this.level.getRecipeManager().getRecipeFor((RecipeType)MolecularMetamorpherRecipe.Type.INSTANCE, this.getRecipeInput(), this.level);
        return holder.map(RecipeHolder::value).orElse(null);
    }

    public RecipeInput getRecipeInput() {
        return new RecipeInput(){

            public ItemStack getItem(int slot) {
                return switch (slot) {
                    case 0 -> MolecularMetamorpherEntity.this.inputHandler.getStackInSlot(0).copy();
                    case 1 -> MolecularMetamorpherEntity.this.inputHandler.getStackInSlot(1).copy();
                    case 2 -> MolecularMetamorpherEntity.this.inputHandler.getStackInSlot(2).copy();
                    default -> ItemStack.EMPTY;
                };
            }

            public int size() {
                return 3;
            }
        };
    }

    public void setProcessing(boolean isProcessing) {
        this.isProcessing = isProcessing;
        this.setChanged();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(int time) {
        this.processTime = time;
        this.setChanged();
    }

    public int getProcessProgress() {
        return this.processProgress;
    }

    public void setProcessProgress(int progress) {
        this.processProgress = progress;
        this.setChanged();
    }

    public void incrementProcessProgress() {
        ++this.processProgress;
        this.setChanged();
    }

    public void setRecipeId(MolecularMetamorpherRecipe recipe) {
        this.recipeId = recipe.getId();
        this.setChanged();
    }

    public void setRecipeCost(int cost) {
        this.recipeCost = cost;
        this.setChanged();
    }

    public void resetAll() {
        this.processProgress = 0;
        this.processTime = 0;
        this.recipeId = null;
        this.recipeCost = 0;
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        super.setChanged();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inputHandler.deserializeNBT(provider, tag.getCompound("Inputs"));
        this.outputHandler.deserializeNBT(provider, tag.getCompound("Outputs"));
        this.savedInputs.deserializeNBT(provider, tag.getCompound("Saved"));
        this.isProcessing = tag.getBoolean("IsProcessing");
        this.processTime = tag.getInt("ProcessTime");
        this.processProgress = tag.getInt("ProcessProgress");
        this.recipeId = ResourceLocation.bySeparator((String)tag.getString("RecipeID"), (char)':');
        this.recipeCost = tag.getInt("RecipeCost");
        this.lockInputs = tag.getBoolean("LockInputs");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inputs", (Tag)this.inputHandler.serializeNBT(provider));
        tag.put("Outputs", (Tag)this.outputHandler.serializeNBT(provider));
        tag.put("Saved", (Tag)this.savedInputs.serializeNBT(provider));
        tag.putBoolean("IsProcessing", this.isProcessing);
        tag.putInt("ProcessTime", this.processTime);
        tag.putInt("ProcessProgress", this.processProgress);
        tag.putInt("RecipeCost", this.recipeCost);
        tag.putBoolean("LockInputs", this.lockInputs);
        if (this.recipeId != null) {
            tag.putString("RecipeID", this.recipeId.toString());
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.inputHandler.deserializeNBT(provider, tag.getCompound("Inputs"));
        this.outputHandler.deserializeNBT(provider, tag.getCompound("Outputs"));
        this.savedInputs.deserializeNBT(provider, tag.getCompound("Saved"));
        this.isProcessing = tag.getBoolean("IsProcessing");
        this.processTime = tag.getInt("ProcessTime");
        this.processProgress = tag.getInt("ProcessProgress");
        this.recipeId = ResourceLocation.bySeparator((String)tag.getString("RecipeID"), (char)':');
        this.recipeCost = tag.getInt("RecipeCost");
        this.lockInputs = tag.getBoolean("LockInputs");
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.put("Inputs", (Tag)this.inputHandler.serializeNBT(provider));
        tag.put("Outputs", (Tag)this.outputHandler.serializeNBT(provider));
        tag.put("Saved", (Tag)this.savedInputs.serializeNBT(provider));
        tag.putBoolean("IsProcessing", this.isProcessing);
        tag.putInt("ProcessTime", this.processTime);
        tag.putInt("ProcessProgress", this.processProgress);
        tag.putInt("RecipeCost", this.recipeCost);
        tag.putBoolean("LockInputs", this.lockInputs);
        if (this.recipeId != null) {
            tag.putString("RecipeID", this.recipeId.toString());
        }
        return tag;
    }
}

