/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities.bibliophage.bookshelves;

import com.cyanogen.cognition.block.ForgottenDustBlock;
import com.cyanogen.cognition.block.bibliophage.agar.InsightfulAgarBlock;
import com.cyanogen.cognition.block_entities.bibliophage.AbstractInfectiveEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterBlocks;
import com.cyanogen.cognition.registries.RegisterItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectedBookshelfEntity
extends AbstractInfectiveEntity {
    int timeTillSpawn = -99;
    final int spawnDelayMin;
    final int spawnDelayMax;
    final int orbValue;
    final int spawns;
    int decayValue = 0;
    double infectivity = 0.02;
    boolean redstoneEnabled = false;

    public AbstractInfectedBookshelfEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int spawnDelayMin, int spawnDelayMax, int orbValue, int spawns) {
        super(type, pos, state);
        this.spawnDelayMin = spawnDelayMin;
        this.spawnDelayMax = spawnDelayMax;
        this.orbValue = orbValue;
        this.spawns = spawns;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean hasSignal = level.hasNeighborSignal(pos);
        if (blockEntity instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)((Object)blockEntity);
            if (!bookshelf.redstoneEnabled || hasSignal) {
                if (bookshelf.decayValue >= bookshelf.spawns) {
                    bookshelf.decay(level, pos);
                } else {
                    if (bookshelf.timeTillSpawn == -99) {
                        bookshelf.resetSpawnDelay();
                    } else if (bookshelf.timeTillSpawn <= 0) {
                        bookshelf.handleExperience(level, pos);
                        bookshelf.incrementDecayValue();
                        bookshelf.resetSpawnDelay();
                    } else {
                        bookshelf.decrementSpawnDelay();
                    }
                    if (level.getGameTime() % 20L == 0L && Math.random() <= bookshelf.infectivity) {
                        bookshelf.infectAdjacent(level, pos);
                    }
                }
            }
        }
    }

    public void resetSpawnDelay() {
        int delay = (int)((double)this.spawnDelayMin + Math.floor((double)(this.spawnDelayMax - this.spawnDelayMin) * Math.random()));
        double bonus = this.getTotalBonus(1);
        if (bonus > 1.0) {
            delay = Math.max((int)((double)delay / bonus), 2);
        }
        this.timeTillSpawn = delay;
        this.setChanged();
    }

    public void decrementSpawnDelay() {
        --this.timeTillSpawn;
        this.setChanged();
    }

    public void handleExperience(Level level, BlockPos pos) {
        int value = this.orbValue;
        double bonus = this.getTotalBonus(2);
        if (!level.isClientSide) {
            if (bonus > 1.0) {
                value = Math.min(Short.MAX_VALUE, (int)((double)value * bonus));
            }
            ServerLevel server = (ServerLevel)level;
            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, value);
            orb.setDeltaMovement(0.0, 0.0, 0.0);
            server.addFreshEntity((Entity)orb);
        }
    }

    public void incrementDecayValue() {
        ++this.decayValue;
        this.setChanged();
    }

    public void decay(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            double chance = (Double)Config.COMMON.dropDustChance.get();
            ItemStack drops = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
            if (Math.random() <= chance) {
                Block.dropResources((BlockState)this.getBlockState(), (Level)level, (BlockPos)pos, (BlockEntity)this, null, (ItemStack)drops);
            }
            level.playSound(null, pos, SoundEvents.WART_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)((ForgottenDustBlock)((Object)RegisterBlocks.FORGOTTEN_DUST_BLOCK.get())).defaultBlockState()));
            level.removeBlockEntity(pos);
            level.removeBlock(pos, false);
        }
    }

    public boolean toggleActivity() {
        this.redstoneEnabled = !this.redstoneEnabled;
        this.setChanged();
        return this.redstoneEnabled;
    }

    public int getDecayValue() {
        return this.decayValue;
    }

    public int getOrbValue() {
        return this.orbValue;
    }

    public int getSpawns() {
        return this.spawns;
    }

    public int countNeighborsOfType(int type, List<BlockPos> neighbors) {
        int count;
        block3: {
            Block extravagant;
            Level level;
            block2: {
                level = this.getLevel();
                InsightfulAgarBlock insightful = (InsightfulAgarBlock)((Object)RegisterBlocks.INSIGHTFUL_AGAR.get());
                extravagant = (Block)RegisterBlocks.EXTRAVAGANT_AGAR.get();
                count = 0;
                if (type != 1) break block2;
                for (BlockPos pos : neighbors) {
                    if (level == null || !level.getBlockState(pos).is((Block)RegisterBlocks.INSIGHTFUL_AGAR.get())) continue;
                    ++count;
                }
                break block3;
            }
            if (type != 2) break block3;
            for (BlockPos pos : neighbors) {
                if (level == null || !level.getBlockState(pos).is(extravagant)) continue;
                ++count;
            }
        }
        return Math.min(count, 6);
    }

    public double getTotalBonus(int type) {
        int faces = this.countNeighborsOfType(type, this.getAdjacents(this.getBlockPos()));
        int edges = this.countNeighborsOfType(type, this.getEdgeBlocks(this.getBlockPos()));
        int vertices = this.countNeighborsOfType(type, this.getVertexBlocks(this.getBlockPos()));
        double faceBonus = (Double)Config.COMMON.agarFaceBonus.get();
        double edgeBonus = (Double)Config.COMMON.agarEdgeBonus.get();
        double vertexBonus = (Double)Config.COMMON.agarVertexBonus.get();
        return Math.pow(faceBonus, faces) * Math.pow(edgeBonus, edges) * Math.pow(vertexBonus, vertices);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.decayValue = tag.getInt("DecayValue");
        this.timeTillSpawn = tag.getInt("SpawnDelay");
        this.redstoneEnabled = tag.getBoolean("isRedstoneControllable");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("DecayValue", this.decayValue);
        tag.putInt("SpawnDelay", this.timeTillSpawn);
        tag.putBoolean("isRedstoneControllable", this.redstoneEnabled);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.decayValue = tag.getInt("DecayValue");
        this.timeTillSpawn = tag.getInt("SpawnDelay");
        this.redstoneEnabled = tag.getBoolean("isRedstoneControllable");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("DecayValue", this.decayValue);
        tag.putInt("SpawnDelay", this.timeTillSpawn);
        tag.putBoolean("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

