/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.gui.ExperienceObeliskMenu;
import com.cyanogen.cognition.gui.ExperienceObeliskOptionsScreen;
import com.cyanogen.cognition.network.experience_obelisk.UpdateContents;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ExperienceObeliskScreen
extends AbstractContainerScreen<ExperienceObeliskMenu> {
    private final ResourceLocation texture = ResourceLocation.parse((String)"cognition:textures/gui/screens/experience_obelisk.png");
    private final Level clientLevel;
    public final Inventory inventory;
    public final Component component;
    private final List<Button> buttons = new ArrayList<Button>();

    public ExperienceObeliskScreen(ExperienceObeliskMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.clientLevel = menu.level;
        this.inventory = inventory;
        this.component = component;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.setupWidgetElements();
        super.init();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        BlockEntity blockEntity;
        this.renderBackground(gui, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int x = this.width / 2 - 88;
        int y = this.height / 2 - 83;
        int experiencePoints = 0;
        int levels = 0;
        int fluidAmount = 0;
        int progress = 0;
        BlockPos pos = ((ExperienceObeliskMenu)this.menu).getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            experiencePoints = obelisk.getExperiencePoints();
            levels = obelisk.getLevels();
            fluidAmount = obelisk.getFluidAmount();
            progress = (int)(ExperienceUtils.getProgressToNextLevel(experiencePoints, levels) * 138.0);
        }
        gui.blit(this.texture, x, y, 0, 0, 176, 166);
        gui.blit(this.texture, this.width / 2 - 69, this.height / 2 + 50, 0, 169, 138, 5);
        gui.blit(this.texture, this.width / 2 - 69, this.height / 2 + 50, 0, 173, progress, 5);
        gui.drawCenteredString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk"), this.width / 2, this.height / 2 - 76, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.store"), this.width / 2 - 77, this.height / 2 - 56, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.retrieve"), this.width / 2 - 77, this.height / 2 - 10, 0xFFFFFF);
        gui.drawCenteredString(this.font, fluidAmount + " mB", this.width / 2, this.height / 2 + 35, 0xFFFFFF);
        gui.drawCenteredString(this.font, String.valueOf(levels), this.width / 2, this.height / 2 + 60, 5111570);
        this.clearWidgets();
        this.loadWidgetElements();
        for (Renderable widget : this.renderables) {
            widget.render(gui, mouseX, mouseY, partialTick);
        }
        int infoX = this.width / 2;
        int infoY = this.height / 2 + 55;
        int hoverAreaX = 80;
        int hoverAreaY = 14;
        ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
        MutableComponent content = Component.translatable((String)"tooltip.cognition.experience_obelisk.xp", (Object[])new Object[]{Component.literal((String)String.valueOf(experiencePoints)).withStyle(ChatFormatting.GREEN)});
        tooltipList.add(content);
        if (mouseX >= infoX - hoverAreaX / 2 && mouseX <= infoX + hoverAreaX / 2 && mouseY >= infoY - hoverAreaY / 2 && mouseY <= infoY + hoverAreaY / 2) {
            gui.renderTooltip(this.font, tooltipList, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics gui, float f, int a, int b) {
    }

    public static void updateContents(ExperienceObeliskMenu menu, int levels, String request) {
        BlockPos pos = menu.getBlockPos();
        if (pos != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateContents(pos, levels, request), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void loadWidgetElements() {
        if (!this.buttons.isEmpty()) {
            for (Button button : this.buttons) {
                button.setFocused(false);
                this.addRenderableWidget((GuiEventListener)button);
            }
        }
    }

    private void setupWidgetElements() {
        this.buttons.clear();
        int buttonWidth = 50;
        int buttonHeight = 20;
        int spacing = 2;
        int y1 = 43;
        int y2 = -3;
        Button settings = this.menuSwitchingButton(this.width / 2 + 91, this.height / 2 - 78, 20, 20);
        Button deposit1 = this.xpHandlingButton((int)((double)((float)this.width / 2.0f) - 1.5 * (double)buttonWidth - (double)spacing), this.height / 2 - y1, buttonWidth, buttonHeight, "FILL", 1);
        Button deposit10 = this.xpHandlingButton(this.width / 2 - buttonWidth / 2, this.height / 2 - y1, buttonWidth, buttonHeight, "FILL", 10);
        Button depositAll = this.xpHandlingButton((int)((double)((float)this.width / 2.0f) + 0.5 * (double)buttonWidth + (double)spacing), this.height / 2 - y1, buttonWidth, buttonHeight, "FILL_ALL", 0);
        Button withdraw1 = this.xpHandlingButton((int)((double)((float)this.width / 2.0f) - 1.5 * (double)buttonWidth - (double)spacing), this.height / 2 - y2, buttonWidth, buttonHeight, "DRAIN", 1);
        Button withdraw10 = this.xpHandlingButton(this.width / 2 - buttonWidth / 2, this.height / 2 - y2, buttonWidth, buttonHeight, "DRAIN", 10);
        Button withdrawAll = this.xpHandlingButton((int)((double)((float)this.width / 2.0f) + 0.5 * (double)buttonWidth + (double)spacing), this.height / 2 - y2, buttonWidth, buttonHeight, "DRAIN_ALL", 0);
        this.buttons.add(settings);
        this.buttons.add(deposit1);
        this.buttons.add(deposit10);
        this.buttons.add(depositAll);
        this.buttons.add(withdraw1);
        this.buttons.add(withdraw10);
        this.buttons.add(withdrawAll);
    }

    public Button xpHandlingButton(int x, int y, int width, int height, String request, int levels) {
        Component message = this.getMessage(request, levels);
        Tooltip tooltip = this.getTooltip(request, levels);
        return Button.builder((Component)message, onPress -> ExperienceObeliskScreen.updateContents((ExperienceObeliskMenu)this.menu, levels, request)).bounds(x, y, width, height).tooltip(tooltip).build();
    }

    public Component getMessage(String request, int levels) {
        return switch (request) {
            case "FILL" -> Component.literal((String)("+" + levels)).withStyle(ChatFormatting.GREEN);
            case "FILL_ALL" -> Component.literal((String)"+All").withStyle(ChatFormatting.GREEN);
            case "DRAIN" -> Component.literal((String)("-" + levels)).withStyle(ChatFormatting.RED);
            case "DRAIN_ALL" -> Component.literal((String)"-All").withStyle(ChatFormatting.RED);
            default -> Component.empty();
        };
    }

    @Nullable
    public Tooltip getTooltip(String request, int levels) {
        return switch (request) {
            case "FILL" -> Tooltip.create((Component)Component.translatable((String)("tooltip.cognition.experience_obelisk.add" + levels)));
            case "FILL_ALL" -> Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.addAll"));
            case "DRAIN" -> Tooltip.create((Component)Component.translatable((String)("tooltip.cognition.experience_obelisk.drain" + levels)));
            case "DRAIN_ALL" -> Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.drainAll"));
            default -> null;
        };
    }

    public Button menuSwitchingButton(int x, int y, int width, int height) {
        MutableComponent message = Component.translatable((String)"button.cognition.experience_obelisk.settings");
        Tooltip tooltip = Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.settings"));
        return Button.builder((Component)message, onPress -> Minecraft.getInstance().setScreen((Screen)new ExperienceObeliskOptionsScreen((ExperienceObeliskMenu)this.menu, this.inventory, this.component))).bounds(x, y, width, height).tooltip(tooltip).build();
    }
}

