/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.MolecularMetamorpherEntity;
import com.cyanogen.cognition.gui.MolecularMetamorpherMenu;
import com.cyanogen.cognition.gui.MolecularMetamorpherScreen;
import com.cyanogen.cognition.network.molecular_metamorpher.UpdateLockedStatus;
import com.cyanogen.cognition.network.shared.UpdateRedstone;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class MolecularMetamorpherOptionsScreen
extends Screen {
    private final ResourceLocation texture = ResourceLocation.parse((String)"cognition:textures/gui/screens/experience_obelisk.png");
    private final MolecularMetamorpherMenu menu;
    private final Level clientLevel;
    private final List<Button> buttons = new ArrayList<Button>();

    public MolecularMetamorpherOptionsScreen(MolecularMetamorpherMenu menu, Level level) {
        super(menu.component);
        this.menu = menu;
        this.clientLevel = level;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Component getTitle() {
        return Component.empty();
    }

    protected void init() {
        this.setupWidgetElements();
        super.init();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int textureWidth = 256;
        int textureHeight = 256;
        int x = this.width / 2 - 88;
        int y = this.height / 2 - 83;
        gui.blit(this.texture, x, y, 0.0f, 0.0f, 176, 166, textureWidth, textureHeight);
        gui.drawCenteredString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.settings"), this.width / 2, this.height / 2 - 76, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.molecular_metamorpher.lock_inputs"), this.width / 2 - 77, this.height / 2 - 56, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.redstone"), this.width / 2 - 77, this.height / 2 - 10, 0xFFFFFF);
        this.clearWidgets();
        this.modifyButtonMessages();
        this.loadWidgetElements();
        for (Renderable widget : this.renderables) {
            widget.render(gui, mouseX, mouseY, partialTick);
        }
    }

    private void modifyButtonMessages() {
        BlockEntity blockEntity;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof MolecularMetamorpherEntity) {
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)blockEntity;
            if (metamorpher.isRedstoneEnabled()) {
                this.buttons.get(1).setMessage((Component)Component.translatable((String)"button.cognition.experience_obelisk.enabled"));
            } else {
                this.buttons.get(1).setMessage((Component)Component.translatable((String)"button.cognition.experience_obelisk.ignored"));
            }
            if (metamorpher.inputsAreLocked()) {
                this.buttons.get(2).setMessage((Component)Component.translatable((String)"button.cognition.molecular_metamorpher.unlock"));
                this.buttons.get(2).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.molecular_metamorpher.options.unlock")));
            } else {
                this.buttons.get(2).setMessage((Component)Component.translatable((String)"button.cognition.molecular_metamorpher.lock"));
                if (metamorpher.inputsAreEmpty()) {
                    this.buttons.get(2).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.molecular_metamorpher.options.lock.inputsempty")));
                } else {
                    this.buttons.get(2).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.molecular_metamorpher.options.lock")));
                }
            }
        } else {
            this.buttons.get(1).setMessage((Component)Component.translatable((String)"button.cognition.experience_obelisk.ignored"));
            this.buttons.get(2).setMessage((Component)Component.translatable((String)"button.cognition.molecular_metamorpher.lock"));
        }
    }

    private void loadWidgetElements() {
        if (!this.buttons.isEmpty()) {
            for (Button b : this.buttons) {
                b.setFocused(false);
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    private void setupWidgetElements() {
        this.buttons.clear();
        int w = 50;
        int h = 20;
        int y1 = 43;
        int y2 = -3;
        Button back = Button.builder((Component)Component.translatable((String)"button.cognition.experience_obelisk.back"), onPress -> Minecraft.getInstance().setScreen((Screen)new MolecularMetamorpherScreen(this.menu, this.menu.inventory, this.menu.component))).size(20, 20).pos(this.width / 2 + 91, this.height / 2 - 78).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.back"))).build();
        Button toggleInputLock = Button.builder((Component)Component.empty(), onPress -> this.toggleLockedStatus()).size(w, h).pos(this.width / 2 - 25, this.height / 2 - y1).build();
        Button toggleRedstone = Button.builder((Component)Component.empty(), onPress -> this.toggleRedstone()).size(w, h).pos(this.width / 2 - 25, this.height / 2 - y2).build();
        this.buttons.add(back);
        this.buttons.add(toggleRedstone);
        this.buttons.add(toggleInputLock);
    }

    private void toggleRedstone() {
        BlockEntity blockEntity;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof MolecularMetamorpherEntity) {
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)blockEntity;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateRedstone(this.menu.getBlockPos(), !metamorpher.isRedstoneEnabled()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void toggleLockedStatus() {
        MolecularMetamorpherEntity metamorpher;
        BlockEntity blockEntity;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof MolecularMetamorpherEntity && (!(metamorpher = (MolecularMetamorpherEntity)blockEntity).inputsAreEmpty() || metamorpher.inputsAreLocked())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateLockedStatus(this.menu.getBlockPos().getX(), this.menu.getBlockPos().getY(), this.menu.getBlockPos().getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

