/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.block_entities.PrecisionDispellerEntity;
import com.cyanogen.cognition.registries.RegisterMenus;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PrecisionDispellerMenu
extends AbstractContainerMenu {
    public final SimpleContainer container = new SimpleContainer(2);
    private ContainerData blockPositionData;
    public final Player player;

    public PrecisionDispellerMenu(int id, Inventory inventory) {
        this(id, inventory, null);
        this.blockPositionData = new SimpleContainerData(3);
        this.addDataSlots(this.blockPositionData);
    }

    public PrecisionDispellerMenu(int id, Inventory inventory, final @Nullable BlockPos pos) {
        super((MenuType)RegisterMenus.PRECISION_DISPELLER_MENU.get(), id);
        this.player = inventory.player;
        if (pos != null) {
            this.blockPositionData = new SimpleContainerData(3);
            this.blockPositionData.set(0, pos.getX());
            this.blockPositionData.set(1, pos.getY());
            this.blockPositionData.set(2, pos.getZ());
            this.addDataSlots(this.blockPositionData);
            this.sendAllDataToRemote();
        } else {
            this.blockPositionData = new SimpleContainerData(3);
        }
        this.addSlot(new Slot(this, (Container)this.container, 0, 17, 18){

            public void onTake(Player player, ItemStack stack) {
                this.container.setItem(1, ItemStack.EMPTY);
                super.onTake(player, stack);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot((Container)this.container, 1, 17, 52){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                Level level = player.level();
                if (!level.isClientSide) {
                    assert (pos != null);
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof PrecisionDispellerEntity) {
                        PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)blockEntity;
                        PrecisionDispellerMenu.this.handleExperience(this.container.getItem(0), stack, level, player, dispeller);
                        PrecisionDispellerMenu.this.handleAnimation(level, pos);
                    }
                }
                player.playSound(SoundEvents.GRINDSTONE_USE, 1.0f, 1.0f);
                this.container.setItem(0, ItemStack.EMPTY);
                super.onTake(player, stack);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.blockPositionData.get(0), this.blockPositionData.get(1), this.blockPositionData.get(2));
    }

    public void handleExperience(ItemStack inputItem, ItemStack outputItem, Level level, Player player, PrecisionDispellerEntity dispeller) {
        player.playSound(SoundEvents.GRINDSTONE_USE, 0.7f, 1.0f);
        if (!level.isClientSide) {
            ServerLevel server = (ServerLevel)level;
            Holder removed = null;
            int enchLevel = 0;
            ItemEnchantments inputEnchantments = inputItem.getTagEnchantments();
            ItemEnchantments outputEnchantments = outputItem.getTagEnchantments();
            for (Object2IntMap.Entry entry : inputEnchantments.entrySet()) {
                if (outputEnchantments.keySet().contains(entry.getKey())) continue;
                removed = (Holder)entry.getKey();
                enchLevel = entry.getIntValue();
                break;
            }
            if (removed != null) {
                if (dispeller.isBound() && dispeller.getBoundObelisk() != null) {
                    this.handleExperienceBound((Holder<Enchantment>)removed, enchLevel, server, dispeller.getBoundObelisk(), player);
                } else {
                    this.handleExperienceUnbound(removed, enchLevel, server, player);
                }
            }
        }
    }

    public void handleExperienceBound(Holder<Enchantment> removed, int enchLevel, ServerLevel server, ExperienceObeliskEntity obelisk, Player player) {
        BlockPos pos = this.getBlockPos();
        if (removed.is(EnchantmentTags.CURSE)) {
            if (obelisk.getFluidAmount() >= 27900) {
                obelisk.drain(27900);
            } else {
                int remainder = 1395 - obelisk.getFluidAmount() / 20;
                obelisk.setFluid(0);
                player.giveExperiencePoints(-remainder);
            }
        } else {
            int points = ((Enchantment)removed.value()).getMinCost(enchLevel);
            if (obelisk.getSpace() / 20 < points) {
                int remainder = points - obelisk.getSpace() / 20;
                obelisk.setFluid(ExperienceObeliskEntity.capacity);
                ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, remainder);
                server.addFreshEntity((Entity)orb);
            } else {
                obelisk.fill(points * 20);
            }
        }
    }

    public void handleExperienceUnbound(Holder<Enchantment> removed, int enchLevel, ServerLevel server, Player player) {
        BlockPos pos = this.getBlockPos();
        if (removed.is(EnchantmentTags.CURSE)) {
            player.giveExperiencePoints(-1395);
        } else {
            int points = ((Enchantment)removed.value()).getMinCost(enchLevel);
            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, points);
            server.addFreshEntity((Entity)orb);
        }
    }

    public void handleAnimation(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PrecisionDispellerEntity) {
            PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)blockEntity;
            dispeller.triggerUseAnimation();
        }
    }

    public void removed(Player player) {
        ItemStack item = this.container.getItem(0);
        if (!player.addItem(item)) {
            player.drop(item, false);
        }
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        return player.position().distanceTo(Vec3.atCenterOf((Vec3i)this.getBlockPos())) < 7.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        BlockPos pos = this.getBlockPos();
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            BlockEntity blockEntity;
            if (index == 0) {
                this.container.setItem(1, ItemStack.EMPTY);
            } else if (index == 1 && !player.level().isClientSide && (blockEntity = player.level().getBlockEntity(pos)) instanceof PrecisionDispellerEntity) {
                PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)blockEntity;
                this.handleExperience(((Slot)this.slots.get(0)).getItem(), ((Slot)this.slots.get(1)).getItem(), player.level(), player, dispeller);
                this.container.setItem(0, ItemStack.EMPTY);
                this.handleAnimation(player.level(), pos);
            }
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 2 ? !this.moveItemStackTo(itemstack1, 2, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 2, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

