/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block.bibliophage.bookshelves.InfectedArchiversBookshelfBlock;
import com.cyanogen.cognition.block.bibliophage.bookshelves.InfectedBookshelfBlock;
import com.cyanogen.cognition.block.bibliophage.bookshelves.InfectedEnchantedBookshelfBlock;
import com.cyanogen.cognition.block_entities.bibliophage.agar.FluorescentAgarEntity;
import com.cyanogen.cognition.registries.RegisterBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BibliophageItem
extends Item {
    public BibliophageItem(Item.Properties p) {
        super(p);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (BibliophageItem.getValidBlocksForInfection().contains(block)) {
            BibliophageItem.infectBlock(level, pos, block);
            if (player != null && !player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public static List<Block> getValidBlocksForInfection() {
        ArrayList<Block> list = new ArrayList<Block>();
        list.add(Blocks.BOOKSHELF);
        list.add((Block)RegisterBlocks.ENCHANTED_BOOKSHELF.get());
        list.add((Block)RegisterBlocks.ARCHIVERS_BOOKSHELF.get());
        list.add((Block)RegisterBlocks.FLUORESCENT_AGAR.get());
        return list;
    }

    public static void infectBlock(Level level, BlockPos pos, Block block) {
        BlockState state = null;
        if (!level.isClientSide) {
            boolean success;
            if (block.equals(RegisterBlocks.FLUORESCENT_AGAR.get())) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof FluorescentAgarEntity) {
                    FluorescentAgarEntity agarEntity = (FluorescentAgarEntity)blockEntity;
                    agarEntity.incrementInfectionProgress();
                }
                return;
            }
            if (block.equals(Blocks.BOOKSHELF)) {
                state = ((InfectedBookshelfBlock)((Object)RegisterBlocks.INFECTED_BOOKSHELF.get())).defaultBlockState();
            } else if (block.equals(RegisterBlocks.ENCHANTED_BOOKSHELF.get())) {
                state = ((InfectedEnchantedBookshelfBlock)((Object)RegisterBlocks.INFECTED_ENCHANTED_BOOKSHELF.get())).defaultBlockState();
            } else if (block.equals(RegisterBlocks.ARCHIVERS_BOOKSHELF.get())) {
                state = ((InfectedArchiversBookshelfBlock)((Object)RegisterBlocks.INFECTED_ARCHIVERS_BOOKSHELF.get())).defaultBlockState();
            }
            if (state != null && (success = level.setBlockAndUpdate(pos, state))) {
                level.playSound(null, pos, SoundEvents.WART_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
            }
        }
    }
}

