/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BottleDaydreamItem
extends BottleItem {
    public BottleDaydreamItem(Item.Properties p) {
        super(p);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 60));
            if (!player.isCreative()) {
                stack.shrink(1);
                ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.getInventory().add(bottle)) {
                    player.drop(bottle, false);
                }
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }
}

