/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

public class CognitiveToolset {
    public static final AttributeModifier HANDHELD_RANGE = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"handheld_range"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static Tier COGNITIVE_TIER = new Tier(){

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getUses() {
            return 835;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 3.0f;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.COGNITIVE_ALLOY.get()});
        }
    };

    public static List<ItemAttributeModifiers.Entry> increasedReach() {
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>();
        list.add(new ItemAttributeModifiers.Entry(Attributes.BLOCK_INTERACTION_RANGE, HANDHELD_RANGE, EquipmentSlotGroup.MAINHAND));
        list.add(new ItemAttributeModifiers.Entry(Attributes.ENTITY_INTERACTION_RANGE, HANDHELD_RANGE, EquipmentSlotGroup.MAINHAND));
        return list;
    }

    public static Item.Properties createCustomAttributes(Item.Properties properties, @Nullable ItemAttributeModifiers baseModifiers, List<ItemAttributeModifiers.Entry> extraModifiers) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (baseModifiers != null) {
            for (ItemAttributeModifiers.Entry entry : baseModifiers.modifiers()) {
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
        }
        for (ItemAttributeModifiers.Entry entry : extraModifiers) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        return properties.attributes(builder.build());
    }

    public static class FlintAndCognitiveAlloyItem
    extends FlintAndSteelItem {
        public FlintAndCognitiveAlloyItem(int maxDamage) {
            super(CognitiveToolset.createCustomAttributes(new Item.Properties(), null, CognitiveToolset.increasedReach()).durability(maxDamage));
        }

        public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
            if (interactionTarget instanceof Creeper) {
                Creeper creeper = (Creeper)interactionTarget;
                creeper.ignite();
                player.level().playSound(player, player.blockPosition(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, player.level().getRandom().nextFloat() * 0.4f + 0.8f);
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        }
    }

    public static class CognitiveBowItem
    extends BowItem {
        private final float velocityMultiplier;
        private final float accuracyMultiplier;

        public CognitiveBowItem(int maxDamage, float velocityMultiplier, float accuracyMultiplier) {
            super(new Item.Properties().durability(maxDamage));
            this.velocityMultiplier = velocityMultiplier;
            this.accuracyMultiplier = accuracyMultiplier;
        }

        public static void registerProperties() {
            ItemProperties.register((Item)((Item)RegisterItems.COGNITIVE_BOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"pulling"), (stack, level, entity, seed) -> CognitiveBowItem.getPull(stack, (Entity)entity, true));
            ItemProperties.register((Item)((Item)RegisterItems.COGNITIVE_BOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"pull"), (stack, level, entity, seed) -> CognitiveBowItem.getPull(stack, (Entity)entity, false));
        }

        public static float getPull(ItemStack stack, Entity entity, boolean binary) {
            float pull = 0.0f;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (stack.getItem() instanceof CognitiveBowItem && Objects.equals(player.getUseItem(), stack)) {
                    pull = binary ? 1.0f : (float)player.getTicksUsingItem() / 20.0f;
                }
            }
            return pull;
        }

        public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
            Player player;
            ItemStack itemstack;
            if (entityLiving instanceof Player && !(itemstack = (player = (Player)entityLiving).getProjectile(stack)).isEmpty()) {
                int i = this.getUseDuration(stack, entityLiving) - timeLeft;
                if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                    return;
                }
                float f = CognitiveBowItem.getPowerForTime((int)i);
                float velocity = f * 3.0f * this.velocityMultiplier;
                float inaccuracy = 1.0f / this.accuracyMultiplier;
                if (!((double)f < 0.1)) {
                    List list = CognitiveBowItem.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        if (!list.isEmpty()) {
                            this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, velocity, inaccuracy, f == 1.0f, null);
                        }
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }

        public String getPercentageString(float multiplier) {
            return Math.round((multiplier - 1.0f) * 100.0f) + "%";
        }

        public static void handleTooltip(ItemTooltipEvent event) {
            List tooltipList = event.getToolTip();
            Item item = event.getItemStack().getItem();
            if (item instanceof CognitiveBowItem) {
                CognitiveBowItem bow = (CognitiveBowItem)item;
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(Component.literal((String)""));
                tooltips.add(Component.translatable((String)"tooltip.cognition.cognitive_bow.firing").withStyle(ChatFormatting.GRAY));
                tooltips.add(Component.translatable((String)"tooltip.cognition.cognitive_bow.velocity_multiplier", (Object[])new Object[]{Component.literal((String)bow.getPercentageString(bow.velocityMultiplier)).withStyle(ChatFormatting.BLUE)}));
                tooltips.add(Component.translatable((String)"tooltip.cognition.cognitive_bow.accuracy_multiplier", (Object[])new Object[]{Component.literal((String)bow.getPercentageString(bow.accuracyMultiplier)).withStyle(ChatFormatting.BLUE)}));
                if (event.getFlags().isAdvanced()) {
                    tooltipList.addAll(tooltipList.size() - 2, tooltips);
                } else {
                    tooltipList.addAll(tooltips);
                }
            }
        }
    }
}

