/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FlaskChaosItem
extends Item {
    public static final int cost = 1;
    final int cooldown = 8;

    public FlaskChaosItem(Item.Properties p) {
        super(p);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        if (player != null && (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 1L) && !player.getCooldowns().isOnCooldown((Item)this)) {
            BlockHitResult result = FlaskChaosItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockPos pos = result.getBlockPos();
            Direction direction = result.getDirection();
            BlockState state = level.getBlockState(pos);
            ItemStack item = player.getItemInHand(hand);
            if (level.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(direction), direction, item)) {
                Block block = state.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketpickup = (BucketPickup)block;
                    test = bucketpickup.pickupBlock(player, (LevelAccessor)level, pos, state);
                    if (!test.isEmpty()) {
                        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                        return this.handlePlayer(player, level);
                    }
                } else {
                    AbstractCauldronBlock block2;
                    test = state.getBlock();
                    if (test instanceof AbstractCauldronBlock && (block2 = (AbstractCauldronBlock)test).isFull(state)) {
                        level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                        return this.handlePlayer(player, level);
                    }
                    if (state.hasBlockEntity()) {
                        int drainAmount;
                        BlockEntity entity = level.getBlockEntity(pos);
                        assert (entity != null);
                        IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
                        if (handler != null && (drainAmount = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount()) != 0) {
                            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            return this.handlePlayer(player, level);
                        }
                    }
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult handlePlayer(Player player, Level level) {
        int k = player.isCreative() ? 0 : 1;
        player.getCooldowns().addCooldown((Item)this, 8);
        player.giveExperiencePoints(-1 * k);
        player.playSound((SoundEvent)RegisterSounds.FLASK_FILL_VOID.get(), MiscUtils.randomInRange(1.0f, 1.2f), MiscUtils.randomInRange(0.8f, 1.2f));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

