/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FlaskHadesItem
extends Item {
    public static final int cost = 160;
    final int cooldown = 25;
    private final FluidStack fluidStack = new FluidStack(Fluids.LAVA.getSource(), 1000);

    public FlaskHadesItem(Item.Properties p) {
        super(p);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos placePos = context.getClickedPos().relative(context.getClickedFace());
        Direction direction = context.getClickedFace();
        if (player != null && (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 160L) && !player.getCooldowns().isOnCooldown((Item)this)) {
            boolean canModifyClicked = level.mayInteract(player, clickedPos) && player.mayUseItemAt(clickedPos, context.getClickedFace(), player.getItemInHand(context.getHand()));
            boolean canPlace = level.mayInteract(player, placePos) && player.mayUseItemAt(placePos, context.getClickedFace(), player.getItemInHand(context.getHand()));
            boolean edit = !player.isShiftKeyDown() && canModifyClicked;
            BlockState clickedState = level.getBlockState(clickedPos);
            BlockState stateToReplace = level.getBlockState(placePos);
            if (clickedState.getBlock() instanceof AbstractCauldronBlock && edit) {
                if (clickedState.getBlock().equals(Blocks.CAULDRON)) {
                    level.setBlockAndUpdate(clickedPos, Blocks.LAVA_CAULDRON.defaultBlockState());
                    return this.handlePlayer(player, level);
                }
                return InteractionResult.FAIL;
            }
            if (clickedState.hasBlockEntity() && edit) {
                int drainAmount;
                BlockEntity entity = level.getBlockEntity(clickedPos);
                assert (entity != null);
                IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, clickedPos, (Object)direction);
                if (handler != null && (drainAmount = handler.fill(this.fluidStack, IFluidHandler.FluidAction.SIMULATE)) != 0) {
                    handler.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return this.handlePlayer(player, level);
                }
            } else if ((stateToReplace.isAir() || stateToReplace.canBeReplaced((Fluid)Fluids.LAVA)) && canPlace) {
                level.setBlockAndUpdate(placePos, Blocks.LAVA.defaultBlockState());
                return this.handlePlayer(player, level);
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult handlePlayer(Player player, Level level) {
        int k = player.isCreative() ? 0 : 1;
        player.getCooldowns().addCooldown((Item)this, 25);
        player.giveExperiencePoints(-160 * k);
        player.playSound((SoundEvent)RegisterSounds.FLASK_EMPTY_LAVA.get(), MiscUtils.randomInRange(0.8f, 1.0f), MiscUtils.randomInRange(0.8f, 1.0f));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

