/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FlaskPoseidonItem
extends Item {
    public static final int cost = 7;
    final int cooldown = 10;
    private final FluidStack fluidStack = new FluidStack(Fluids.WATER.getSource(), 1000);

    public FlaskPoseidonItem(Item.Properties p) {
        super(p);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos clickedPos = context.getClickedPos();
        BlockPos replacePos = context.getClickedPos().relative(context.getClickedFace(), 1);
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Direction direction = context.getClickedFace();
        if (player != null && (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 7L) && !player.getCooldowns().isOnCooldown((Item)this)) {
            boolean canModifyClicked = level.mayInteract(player, clickedPos) && player.mayUseItemAt(clickedPos, context.getClickedFace(), player.getItemInHand(context.getHand()));
            boolean canPlace = level.mayInteract(player, replacePos) && player.mayUseItemAt(replacePos, context.getClickedFace(), player.getItemInHand(context.getHand()));
            boolean edit = !player.isShiftKeyDown() && canModifyClicked;
            BlockState clickedState = level.getBlockState(clickedPos);
            BlockState stateToReplace = level.getBlockState(replacePos);
            if (clickedState.getBlock() instanceof AbstractCauldronBlock && edit) {
                if (clickedState.getBlock().equals(Blocks.CAULDRON)) {
                    level.setBlockAndUpdate(clickedPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().trySetValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(3)));
                    return this.handlePlayer(player, level);
                }
                return InteractionResult.FAIL;
            }
            Block block = clickedState.getBlock();
            if (block instanceof LiquidBlockContainer) {
                LiquidBlockContainer container = (LiquidBlockContainer)block;
                if (edit) {
                    if (container.canPlaceLiquid(player, (BlockGetter)level, clickedPos, clickedState, Fluids.WATER.getSource())) {
                        container.placeLiquid((LevelAccessor)level, clickedPos, clickedState, Fluids.WATER.getSource().defaultFluidState());
                    }
                    return this.handlePlayer(player, level);
                }
            }
            if (clickedState.hasBlockEntity() && edit) {
                int drainAmount;
                BlockEntity entity = level.getBlockEntity(clickedPos);
                assert (entity != null);
                IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, clickedPos, (Object)direction);
                if (handler != null && (drainAmount = handler.fill(this.fluidStack, IFluidHandler.FluidAction.SIMULATE)) != 0) {
                    handler.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return this.handlePlayer(player, level);
                }
            } else if ((stateToReplace.isAir() || stateToReplace.canBeReplaced((Fluid)Fluids.WATER)) && canPlace) {
                if (level.dimensionType().ultraWarm()) {
                    Fluids.WATER.getFluidType().onVaporize(player, level, replacePos, null);
                } else {
                    level.setBlockAndUpdate(replacePos, Blocks.WATER.defaultBlockState());
                }
                return this.handlePlayer(player, level);
            }
        }
        return super.useOn(context);
    }

    public InteractionResult handlePlayer(Player player, Level level) {
        int k = player.isCreative() ? 0 : 1;
        player.getCooldowns().addCooldown((Item)this, 10);
        player.giveExperiencePoints(-7 * k);
        player.playSound((SoundEvent)RegisterSounds.FLASK_EMPTY_WATER.get(), MiscUtils.randomInRange(0.8f, 1.0f), MiscUtils.randomInRange(0.8f, 1.0f));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

