/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.registries.RegisterAttachments;
import com.cyanogen.cognition.registries.RegisterSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MemoryTabletItem
extends Item {
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<BlockPos>> obeliskLocation = RegisterAttachments.MEMORY_TABLET_OBELISK_LOCATION;

    public MemoryTabletItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide) {
            if (player.hasData(obeliskLocation)) {
                BlockPos pos = (BlockPos)player.getData(obeliskLocation);
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.query", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.query_fail"), true);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            if (player != null && player.isShiftKeyDown()) {
                if (!level.isClientSide) {
                    if (obelisk.hasBeenMemorized(player)) {
                        player.removeData(obeliskLocation);
                        player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.unlink", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
                        level.playSound(null, player.blockPosition(), (SoundEvent)RegisterSounds.MEMORY_TABLET_UNLINK.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                    } else {
                        player.setData(obeliskLocation, (Object)pos);
                        player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.link", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
                        level.playSound(null, player.blockPosition(), (SoundEvent)RegisterSounds.MEMORY_TABLET_LINK.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public static void handleDeath(LivingDeathEvent event) {
        Player player;
        boolean keepInventory = ((GameRules.BooleanValue)event.getEntity().level().getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasData(obeliskLocation) && !keepInventory) {
            int levels = player.experienceLevel;
            float progress = player.experienceProgress;
            player.setData(RegisterAttachments.PLAYER_EXPERIENCE_LEVELS_ON_DEATH, (Object)levels);
            player.setData(RegisterAttachments.PLAYER_EXPERIENCE_PROGRESS_ON_DEATH, (Object)Float.valueOf(progress));
        }
    }

    public static void handleExperience(LivingExperienceDropEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasData(obeliskLocation)) {
            event.setDroppedExperience(0);
            event.setCanceled(true);
        }
    }
}

