/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;

public class NeurogelMendingItem
extends Item {
    public static final int maxRepairPoints = 320;
    public static final double maxRepairPercentage = 0.25;

    public NeurogelMendingItem(Item.Properties p) {
        super(p);
    }

    public static void handleItem(ItemStackedOnOtherEvent event) {
        ItemStack itemToRepair = event.getStackedOnItem();
        ItemStack neurogel = event.getCarriedItem();
        Player player = event.getPlayer();
        ItemStack chippedAnvil = new ItemStack((ItemLike)Items.CHIPPED_ANVIL, 1);
        ItemStack anvil = new ItemStack((ItemLike)Items.ANVIL, 1);
        if (neurogel.is((Item)RegisterItems.MENDING_NEUROGEL.get())) {
            if (itemToRepair.isDamaged()) {
                int maxDurability = itemToRepair.getMaxDamage();
                int damage = itemToRepair.getDamageValue();
                int repairAmount = (int)Math.max((double)maxDurability * 0.25, 320.0);
                neurogel.shrink(1);
                itemToRepair.setDamageValue(Math.max(damage - repairAmount, 0));
                player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
                event.setCanceled(true);
            } else if (itemToRepair.is(Items.CHIPPED_ANVIL)) {
                NeurogelMendingItem.setItem(anvil, event.getSlot(), player, neurogel, itemToRepair);
                event.setCanceled(true);
            } else if (itemToRepair.is(Items.DAMAGED_ANVIL)) {
                NeurogelMendingItem.setItem(chippedAnvil, event.getSlot(), player, neurogel, itemToRepair);
                event.setCanceled(true);
            }
        }
    }

    public static void setItem(ItemStack item, Slot slot, Player player, ItemStack stackedOn, ItemStack itemToRepair) {
        stackedOn.shrink(1);
        player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
        if (itemToRepair.getCount() == 1) {
            slot.set(item);
        } else {
            player.addItem(item);
            itemToRepair.shrink(1);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(context.getClickedPos());
        if (player != null && (state.is(Blocks.CHIPPED_ANVIL) || state.is(Blocks.DAMAGED_ANVIL))) {
            BlockState anvil = Blocks.ANVIL.withPropertiesOf(state);
            BlockState chipped = Blocks.CHIPPED_ANVIL.withPropertiesOf(state);
            if (state.is(Blocks.CHIPPED_ANVIL)) {
                level.setBlockAndUpdate(pos, anvil);
            } else if (state.is(Blocks.DAMAGED_ANVIL)) {
                level.setBlockAndUpdate(pos, chipped);
            }
            stack.shrink(1);
            player.playSound((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
            return InteractionResult.CONSUME;
        }
        return super.onItemUseFirst(stack, context);
    }
}

