/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherRecipe
implements Recipe<RecipeInput> {
    private final ArrayList<Tuple<Ingredient, Integer>> ingredients;
    private final ItemStack result;
    private final int cost;
    private final int processTime;
    private final ResourceLocation id;
    public final Ingredient ingredient1;
    public final int count1;
    public final Ingredient ingredient2;
    public final int count2;
    public final Ingredient ingredient3;
    public final int count3;

    public MolecularMetamorpherRecipe(Ingredient ingredient1, int count1, Ingredient ingredient2, int count2, Ingredient ingredient3, int count3, ItemStack result, int cost, int processTime, ResourceLocation id) {
        this.ingredient1 = ingredient1;
        this.count1 = count1;
        this.ingredient2 = ingredient2;
        this.count2 = count2;
        this.ingredient3 = ingredient3;
        this.count3 = count3;
        this.result = result;
        this.cost = cost;
        this.processTime = processTime;
        this.id = id;
        this.ingredients = MolecularMetamorpherRecipe.assembleIngredients(ingredient1, count1, ingredient2, count2, ingredient3, count3);
    }

    public static ArrayList<Tuple<Ingredient, Integer>> assembleIngredients(Ingredient ingredient1, int count1, Ingredient ingredient2, int count2, Ingredient ingredient3, int count3) {
        ArrayList<Tuple<Ingredient, Integer>> ingredients = new ArrayList<Tuple<Ingredient, Integer>>(4);
        ingredients.add(0, new Tuple((Object)Ingredient.EMPTY, (Object)0));
        ingredients.add(1, new Tuple((Object)ingredient1, (Object)count1));
        ingredients.add(2, new Tuple((Object)ingredient2, (Object)count2));
        ingredients.add(3, new Tuple((Object)ingredient3, (Object)count3));
        return ingredients;
    }

    public boolean matches(RecipeInput recipeInput, @Nullable Level level) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (int j = 0; j < 3; ++j) {
            contents.add(recipeInput.getItem(j));
        }
        int tracker = 3;
        block1: for (int k = 1; k <= 3; ++k) {
            Ingredient ingredient = (Ingredient)this.ingredients.get(k).getA();
            int count = (Integer)this.ingredients.get(k).getB();
            if (ingredient.isEmpty() || count <= 0) {
                --tracker;
                continue;
            }
            if (contents.isEmpty()) continue;
            for (ItemStack item : contents) {
                if (!ingredient.test(item) || item.getCount() < count) continue;
                --tracker;
                contents.remove(item);
                continue block1;
            }
        }
        return tracker <= 0;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        for (Tuple<Ingredient, Integer> ingredient : this.ingredients) {
            list.add((Object)((Ingredient)ingredient.getA()));
        }
        return list;
    }

    public ArrayList<Tuple<Ingredient, Integer>> getIngredients(boolean k) {
        return this.ingredients;
    }

    public ItemStack assemble(RecipeInput recipeInput, @Nullable HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public int getCost() {
        return this.cost;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isSpecial() {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isNameFormatting() {
        return this.id.getPath().equals("item_name_formatting");
    }

    public String getInfo() {
        return "----- Molecular Metamorphosis ----- \nID: " + String.valueOf(this.id) + "\nIngredients: \n" + this.getIngredientInfoString() + "Result: " + String.valueOf(this.result) + "\nCost: " + this.cost + "\nProcess Time: " + this.processTime + "\n";
    }

    public String getIngredientInfoString() {
        StringBuilder info = new StringBuilder();
        for (Tuple<Ingredient, Integer> ingredient : this.ingredients) {
            if (((Ingredient)ingredient.getA()).isEmpty() || (Integer)ingredient.getB() <= 0) continue;
            ItemStack first = ((Ingredient)ingredient.getA()).getItems()[0];
            int count = (Integer)ingredient.getB();
            info.append(count).append("- ").append(first.getItem());
            if (((Ingredient)ingredient.getA()).getItems().length > 1) {
                info.append(" etc...");
            }
            info.append("\n");
        }
        return info.toString();
    }

    public static class Serializer
    implements RecipeSerializer<MolecularMetamorpherRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"molecular_metamorphosis");
        private static final MapCodec<MolecularMetamorpherRecipe> CODEC = RecordCodecBuilder.mapCodec(recipeInstance -> recipeInstance.group((App)Ingredient.CODEC.fieldOf("ingredient1").forGetter(recipe -> recipe.ingredient1), (App)Codec.INT.fieldOf("count1").forGetter(recipe -> recipe.count1), (App)Ingredient.CODEC.fieldOf("ingredient2").forGetter(recipe -> recipe.ingredient2), (App)Codec.INT.fieldOf("count2").forGetter(recipe -> recipe.count2), (App)Ingredient.CODEC.fieldOf("ingredient3").forGetter(recipe -> recipe.ingredient3), (App)Codec.INT.fieldOf("count3").forGetter(recipe -> recipe.count3), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("cost").forGetter(recipe -> recipe.cost), (App)Codec.INT.fieldOf("processTime").forGetter(recipe -> recipe.processTime), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(recipe -> recipe.id)).apply((Applicative)recipeInstance, MolecularMetamorpherRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MolecularMetamorpherRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static MolecularMetamorpherRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int count1 = buffer.readInt();
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int count2 = buffer.readInt();
            Ingredient ingredient3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int count3 = buffer.readInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int cost = buffer.readInt();
            int processTime = buffer.readInt();
            ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new MolecularMetamorpherRecipe(ingredient1, count1, ingredient2, count2, ingredient3, count3, result, cost, processTime, id);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, MolecularMetamorpherRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient1);
            buffer.writeInt(recipe.count1);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient2);
            buffer.writeInt(recipe.count2);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient3);
            buffer.writeInt(recipe.count3);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.cost);
            buffer.writeInt(recipe.processTime);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.id);
        }

        public MapCodec<MolecularMetamorpherRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MolecularMetamorpherRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<MolecularMetamorpherRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "molecular_metamorphosis";
    }
}

