/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.gui.MolecularMetamorpherScreen;
import com.cyanogen.cognition.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.cognition.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.cognition.recipe.jei.MolecularMetamorpherTransferHandler;
import com.cyanogen.cognition.recipe.jei.info.EmptyingCategory;
import com.cyanogen.cognition.recipe.jei.info.FillingCategory;
import com.cyanogen.cognition.recipe.jei.info.InfectingCategory;
import com.cyanogen.cognition.recipe.jei.info.PopulateInformationalRecipes;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.RecipeUtils;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CognitionJeiPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MolecularMetamorpherCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FillingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EmptyingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfectingCategory(registration)});
        super.registerCategories(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<MolecularMetamorpherRecipe> metamorpherRecipes = new ArrayList<MolecularMetamorpherRecipe>();
        assert (Minecraft.getInstance().level != null);
        for (RecipeHolder recipe : Minecraft.getInstance().level.getRecipeManager().getRecipes()) {
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof MolecularMetamorpherRecipe)) continue;
            MolecularMetamorpherRecipe metamorpherRecipe = (MolecularMetamorpherRecipe)recipe2;
            metamorpherRecipes.add(metamorpherRecipe);
        }
        metamorpherRecipes.add(RecipeUtils.getEmptyNameFormattingRecipe());
        registration.addRecipes(MolecularMetamorpherCategory.metamorpherType, metamorpherRecipes);
        registration.addRecipes(FillingCategory.fillingType, PopulateInformationalRecipes.populateFillingRecipes());
        registration.addRecipes(EmptyingCategory.emptyingType, PopulateInformationalRecipes.populateEmptyingRecipes());
        registration.addRecipes(InfectingCategory.infectingType, PopulateInformationalRecipes.populateInfectingRecipes());
        ItemStack forgottenDust = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
        registration.addIngredientInfo((Object)forgottenDust, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.cognition.description.forgotten_dust")});
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        hidden.add(((Item)RegisterItems.DUMMY_SWORD.get()).getDefaultInstance());
        hidden.add(((BlockItem)RegisterItems.BIBLIOMANCER_ITEM.get()).getDefaultInstance());
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        super.registerRecipes(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack stack = new ItemStack((ItemLike)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get());
        registration.addRecipeCatalyst(stack, new RecipeType[]{MolecularMetamorpherCategory.metamorpherType});
        super.registerRecipeCatalysts(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MolecularMetamorpherTransferHandler(registration), MolecularMetamorpherCategory.metamorpherType);
        super.registerRecipeTransferHandlers(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MolecularMetamorpherScreen.class, 107, 45, 32, 10, new RecipeType[]{MolecularMetamorpherCategory.metamorpherType});
        super.registerGuiHandlers(registration);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"jei_plugin");
    }
}

