/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei.info;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInformationalRecipe
implements Recipe<RecipeInput> {
    private final Ingredient input;
    private final Ingredient catalyst;
    private final ItemStack output;
    private final String id;
    public final int count;

    public AbstractInformationalRecipe(Ingredient input, Ingredient catalyst, ItemStack output, String id, int count) {
        this.input = input;
        this.catalyst = catalyst;
        this.output = output;
        this.id = id;
        this.count = count;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        list.add((Object)this.catalyst);
        return list;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public ItemStack getResultItem() {
        return this.output.copy();
    }

    public ResourceLocation getId() {
        return ResourceLocation.parse((String)this.id);
    }

    @Nullable
    public RecipeSerializer<?> getSerializer() {
        return null;
    }

    public boolean canCraftInDimensions(int d1, int d2) {
        return false;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }
}

