/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei.info;

import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalCategory;
import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalRecipe;
import com.cyanogen.cognition.recipe.jei.info.EmptyingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EmptyingCategory
extends AbstractInformationalCategory {
    public static final RecipeType<AbstractInformationalRecipe> emptyingType = RecipeType.create((String)"cognition", (String)"emptying", EmptyingRecipe.class);

    public EmptyingCategory(IRecipeCategoryRegistration registration) {
        super(registration);
    }

    public RecipeType<AbstractInformationalRecipe> getRecipeType() {
        return emptyingType;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.cognition.info.emptying.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    @Override
    public Component getProcessTooltip() {
        return Component.translatable((String)"jei.cognition.info.emptying.tooltip");
    }

    @Override
    public void draw(AbstractInformationalRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.createDrawable(this.emptyingBackground, 0, 0, 136, 66).draw(guiGraphics);
        this.arrow.draw(guiGraphics, 35, 21);
        Font font = Minecraft.getInstance().font;
        if (recipe instanceof EmptyingRecipe) {
            EmptyingRecipe emptyingRecipe = (EmptyingRecipe)recipe;
            if (emptyingRecipe.getCognitiumAmount() > 0) {
                this.cognitiumStack.draw(guiGraphics, 110, 18);
            }
            String gain = "+" + emptyingRecipe.getIntegerXpGain() + " XP";
            guiGraphics.drawString(Minecraft.getInstance().font, gain, this.getWidth() - font.width(gain) - 1, this.getHeight() - 7, 0x8B8B8B, false);
        }
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltipBuilder, AbstractInformationalRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        EmptyingRecipe emptyingRecipe;
        int x1 = 110;
        int x2 = x1 + 16;
        int y1 = 18;
        int y2 = y1 + 16;
        if (recipe instanceof EmptyingRecipe && (emptyingRecipe = (EmptyingRecipe)recipe).getCognitiumAmount() > 0 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            MutableComponent amount = Component.translatable((String)"jei.cognition.info.emptying.cognitium_amount", (Object[])new Object[]{Component.literal((String)String.valueOf(emptyingRecipe.getCognitiumAmount())).withStyle(ChatFormatting.GREEN)});
            tooltipBuilder.add((FormattedText)amount);
        }
        super.getTooltip(tooltipBuilder, recipe, recipeSlotsView, mouseX + 14.0, mouseY);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, AbstractInformationalRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setSlotName("input").addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 47, 34).setSlotName("catalyst").addIngredients(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 18).setSlotName("output").addItemStack(recipe.getResultItem());
    }
}

