/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei.info;

import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalCategory;
import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalRecipe;
import com.cyanogen.cognition.recipe.jei.info.FillingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FillingCategory
extends AbstractInformationalCategory {
    public static final RecipeType<AbstractInformationalRecipe> fillingType = RecipeType.create((String)"cognition", (String)"filling", FillingRecipe.class);

    public FillingCategory(IRecipeCategoryRegistration registration) {
        super(registration);
    }

    public RecipeType<AbstractInformationalRecipe> getRecipeType() {
        return fillingType;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.cognition.info.filling.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    @Override
    public Component getProcessTooltip() {
        return Component.translatable((String)"jei.cognition.info.filling.tooltip");
    }

    @Override
    public void draw(AbstractInformationalRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        if (recipe instanceof FillingRecipe) {
            FillingRecipe fillingRecipe = (FillingRecipe)recipe;
            String cost = "-" + fillingRecipe.getIntegerXpCost() + " XP";
            guiGraphics.drawString(Minecraft.getInstance().font, cost, this.getWidth() - font.width(cost) - 1, this.getHeight() - 7, 0x8B8B8B, false);
        }
    }
}

