/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei.info;

import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalCategory;
import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalRecipe;
import com.cyanogen.cognition.recipe.jei.info.InfectingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InfectingCategory
extends AbstractInformationalCategory {
    IRecipeCategoryRegistration registration;
    private final int counterArrowXOffset = 56;
    private final int counterArrowYOffset = 7;
    public static final RecipeType<AbstractInformationalRecipe> infectingType = RecipeType.create((String)"cognition", (String)"infecting", InfectingRecipe.class);

    public InfectingCategory(IRecipeCategoryRegistration registration) {
        super(registration);
        this.registration = registration;
    }

    public RecipeType<AbstractInformationalRecipe> getRecipeType() {
        return infectingType;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.cognition.info.infecting.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.BIBLIOPHAGE.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    @Override
    public void draw(AbstractInformationalRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (recipe.count > 0) {
            this.counterArrow.draw(guiGraphics, 56, 7);
            guiGraphics.drawString(Minecraft.getInstance().font, "x" + recipe.count, 71, 8, 0x8B8B8B, false);
        }
    }

    @Override
    public Component getProcessTooltip() {
        return Component.translatable((String)"jei.cognition.info.infecting.tooltip");
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltipBuilder, AbstractInformationalRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        InfectingRecipe infectingRecipe;
        MutableComponent requiredCount = Component.translatable((String)"jei.cognition.info.infecting.tooltip_count", (Object[])new Object[]{Component.literal((String)String.valueOf(recipe.count)).withStyle(ChatFormatting.GREEN)});
        int counterArrow_x2 = 86;
        int counterArrow_y2 = 16;
        if (recipe instanceof InfectingRecipe && (infectingRecipe = (InfectingRecipe)recipe).getCount() > 0 && mouseX >= 56.0 && mouseX <= (double)counterArrow_x2 && mouseY >= 7.0 && mouseY <= (double)counterArrow_y2) {
            tooltipBuilder.add((FormattedText)requiredCount);
        }
        super.getTooltip(tooltipBuilder, recipe, recipeSlotsView, mouseX, mouseY);
    }
}

