/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei.info;

import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.recipe.jei.info.AbstractInformationalRecipe;
import com.cyanogen.cognition.recipe.jei.info.EmptyingRecipe;
import com.cyanogen.cognition.recipe.jei.info.FillingRecipe;
import com.cyanogen.cognition.recipe.jei.info.InfectingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PopulateInformationalRecipes {
    public static List<AbstractInformationalRecipe> populateFillingRecipes() {
        ArrayList<AbstractInformationalRecipe> recipes = new ArrayList<AbstractInformationalRecipe>();
        recipes.add(new FillingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()}), Items.EXPERIENCE_BOTTLE.getDefaultInstance(), "cognition:experience_bottle_filling", 12.5f));
        recipes.add(new FillingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()}), ((BucketItem)RegisterItems.COGNITIUM_BUCKET.get()).getDefaultInstance(), "cognition:cognitium_bucket_filling", 50.0f));
        return recipes;
    }

    public static List<AbstractInformationalRecipe> populateEmptyingRecipes() {
        ArrayList<AbstractInformationalRecipe> recipes = new ArrayList<AbstractInformationalRecipe>();
        recipes.add(new EmptyingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()}), Items.GLASS_BOTTLE.getDefaultInstance(), "cognition:experience_bottle_emptying", 12.5f));
        recipes.add(new EmptyingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.COGNITIUM_BUCKET.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()}), Items.BUCKET.getDefaultInstance(), "cognition:cognitium_bucket_emptying", 50.0f));
        recipes.addAll(PopulateInformationalRecipes.populateEmptyingRecipesFromConfig());
        return recipes;
    }

    public static List<AbstractInformationalRecipe> populateEmptyingRecipesFromConfig() {
        ArrayList<AbstractInformationalRecipe> recipes = new ArrayList<AbstractInformationalRecipe>();
        Map<String, Float> allowedItemsMap = MiscUtils.getExperienceItemMapFromList((List)Config.COMMON.allowedExperienceItems.get());
        for (Map.Entry<String, Float> entry : allowedItemsMap.entrySet()) {
            ResourceLocation itemResource = ResourceLocation.bySeparator((String)entry.getKey(), (char)':');
            if (!BuiltInRegistries.ITEM.containsKey(itemResource)) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(itemResource);
            recipes.add(new EmptyingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{item}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()}), ItemStack.EMPTY, "cognition:" + itemResource.getPath() + "_emptying", entry.getValue().floatValue()));
        }
        return recipes;
    }

    public static List<AbstractInformationalRecipe> populateInfectingRecipes() {
        ArrayList<AbstractInformationalRecipe> recipes = new ArrayList<AbstractInformationalRecipe>();
        Ingredient catalysts = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.BIBLIOPHAGE.get(), (ItemLike)RegisterItems.INFECTED_BOOKSHELF_ITEM.get(), (ItemLike)RegisterItems.NUTRIENT_AGAR_ITEM.get(), (ItemLike)RegisterItems.INSIGHTFUL_AGAR_ITEM.get(), (ItemLike)RegisterItems.EXTRAVAGANT_AGAR_ITEM.get()});
        recipes.add(new InfectingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOKSHELF}), catalysts, ((BlockItem)RegisterItems.INFECTED_BOOKSHELF_ITEM.get()).getDefaultInstance(), "cognition:infected_bookshelf_infecting"));
        recipes.add(new InfectingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.ARCHIVERS_BOOKSHELF_ITEM.get()}), catalysts, ((BlockItem)RegisterItems.INFECTED_ARCHIVERS_BOOKSHELF_ITEM.get()).getDefaultInstance(), "cognition:infected_archivers_bookshelf_infecting"));
        recipes.add(new InfectingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.ENCHANTED_BOOKSHELF_ITEM.get()}), catalysts, ((BlockItem)RegisterItems.INFECTED_ENCHANTED_BOOKSHELF_ITEM.get()).getDefaultInstance(), "cognition:infected_enchanted_bookshelf_infecting"));
        recipes.add(new InfectingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RegisterItems.FLUORESCENT_AGAR_ITEM.get()}), catalysts, ((BlockItem)RegisterItems.NUTRIENT_AGAR_ITEM.get()).getDefaultInstance(), "cognition:nutrient_agar_infecting", 4));
        return recipes;
    }
}

