/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.utils;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static long levelsToXP(int levels) {
        if (levels <= 16) {
            return (long)(Math.pow(levels, 2.0) + (double)(6L * (long)levels));
        }
        if (levels <= 31) {
            return (long)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        return (long)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
    }

    public static int xpToLevels(long xp) {
        if (xp < 394L) {
            return (int)(Math.sqrt(xp + 9L) - 3.0);
        }
        if (xp < 1628L) {
            return (int)((Math.sqrt(40L * xp - 7839L) + 81.0) * 0.1);
        }
        return (int)((Math.sqrt(72L * xp - 54215L) + 325.0) / 18.0);
    }

    public static long getTotalXP(Player player) {
        return ExperienceUtils.levelsToXP(player.experienceLevel) + (long)Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static long getTotalXP(int levels, float progress) {
        return ExperienceUtils.levelsToXP(levels) + (long)Math.round(progress * (float)ExperienceUtils.getXpNeededForNextLevel(levels));
    }

    public static double getProgressToNextLevel(int experiencePoints, int experienceLevels) {
        long n = (long)experiencePoints - ExperienceUtils.levelsToXP(experienceLevels);
        long m = ExperienceUtils.levelsToXP(experienceLevels + 1) - ExperienceUtils.levelsToXP(experienceLevels);
        return (double)n / (double)m;
    }

    public static long getXpNeededForNextLevel(int experienceLevel) {
        if (experienceLevel >= 30) {
            return 112L + (long)(experienceLevel - 30) * 9L;
        }
        return experienceLevel >= 15 ? (long)(37 + (experienceLevel - 15) * 5) : 7L + (long)experienceLevel * 2L;
    }
}

