/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.phys.Vec3;

public class MiscUtils {
    public static double straightLineDistance(BlockPos a, BlockPos b) {
        double deltaX = Math.abs(a.getX() - b.getX());
        double deltaY = Math.abs(a.getY() - b.getY());
        double deltaZ = Math.abs(a.getZ() - b.getZ());
        return Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0));
    }

    public static float randomInRange(float min, float max) {
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static float coinflip(float a, float b) {
        return Math.random() <= 0.5 ? a : b;
    }

    public static Vec3 generateRandomBlockSurfacePos(BlockPos pos, float distanceFromCtr) {
        double x = pos.getCenter().x;
        double y = pos.getCenter().y;
        double z = pos.getCenter().z;
        double rand = Math.random();
        if (rand <= 0.33) {
            x += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
        } else if (rand <= 0.66) {
            x += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
        } else {
            x += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
        }
        return new Vec3(x, y, z);
    }

    public static List<String> getLinesFromString(String input, int lineWidth, Font font) {
        List lines = font.getSplitter().splitLines(input, lineWidth, Style.EMPTY);
        ArrayList<String> outputLines = new ArrayList<String>();
        for (FormattedText line : lines) {
            outputLines.add(line.getString());
        }
        return outputLines;
    }

    public static Map<String, Float> getExperienceItemMapFromList(List<String> list) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (String element : list) {
            String[] substrings = element.split(" = ");
            if (substrings.length != 2) continue;
            String itemName = substrings[0];
            String xp = substrings[1];
            if (!MiscUtils.isValidFloat(xp)) continue;
            map.put(itemName, Float.valueOf(xp));
        }
        return map;
    }

    public static boolean isValidFloat(String n) {
        try {
            Float.valueOf(n);
            return true;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }
}

