/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities.bibliophage.bookshelves;

import com.cyanogen.experienceobelisk.block_entities.bibliophage.AbstractInfectiveEntity;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.registries.RegisterBlocks;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectedBookshelfEntity
extends AbstractInfectiveEntity {
    int timeTillSpawn = -99;
    final int spawnDelayMin;
    final int spawnDelayMax;
    final int orbValue;
    final int spawns;
    int decayValue = 0;
    final double infectivity = 0.02;
    boolean redstoneEnabled = false;
    public static final Component FROM_BOOKSHELF = Component.m_237113_((String)"SpawnedFromBookshelf");

    public AbstractInfectedBookshelfEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int spawnDelayMin, int spawnDelayMax, int orbValue, int spawns) {
        super(type, pos, state);
        this.spawnDelayMin = spawnDelayMin;
        this.spawnDelayMax = spawnDelayMax;
        this.orbValue = orbValue;
        this.spawns = spawns;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean hasSignal = level.m_276867_(pos);
        if (blockEntity instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)((Object)blockEntity);
            if (!bookshelf.redstoneEnabled || hasSignal) {
                if (bookshelf.decayValue >= bookshelf.spawns) {
                    bookshelf.decay(level, pos);
                } else {
                    if (bookshelf.timeTillSpawn == -99) {
                        bookshelf.resetSpawnDelay();
                    } else if (bookshelf.timeTillSpawn <= 0) {
                        bookshelf.handleExperience(level, pos);
                        bookshelf.incrementDecayValue();
                        bookshelf.resetSpawnDelay();
                    } else {
                        bookshelf.decrementSpawnDelay();
                    }
                    if (level.m_46467_() % 20L == 0L && Math.random() <= bookshelf.infectivity) {
                        bookshelf.infectAdjacent(level, pos);
                    }
                }
            }
        }
    }

    public void resetSpawnDelay() {
        int delay = (int)((double)this.spawnDelayMin + Math.floor((double)(this.spawnDelayMax - this.spawnDelayMin) * Math.random()));
        double bonus = this.getTotalBonus(1);
        if (bonus > 1.0) {
            delay = Math.max((int)((double)delay / bonus), 2);
        }
        this.timeTillSpawn = delay;
        this.m_6596_();
    }

    public void decrementSpawnDelay() {
        --this.timeTillSpawn;
        this.m_6596_();
    }

    public void handleExperience(Level level, BlockPos pos) {
        int value = this.orbValue;
        double bonus = this.getTotalBonus(2);
        if (!level.f_46443_) {
            if (bonus > 1.0) {
                value = Math.min(Short.MAX_VALUE, (int)((double)value * bonus));
            }
            ServerLevel server = (ServerLevel)level;
            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, value);
            orb.m_20334_(0.0, 0.0, 0.0);
            orb.m_6593_(FROM_BOOKSHELF);
            orb.m_20340_(false);
            server.m_7967_((Entity)orb);
        }
    }

    public void incrementDecayValue() {
        ++this.decayValue;
        this.m_6596_();
    }

    public void decay(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            double chance = (Double)Config.COMMON.dropDustChance.get();
            ItemStack drops = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
            if (Math.random() <= chance) {
                Block.m_49881_((BlockState)this.m_58900_(), (Level)level, (BlockPos)pos, (BlockEntity)this, null, (ItemStack)drops);
            }
            level.m_5594_(null, pos, SoundEvents.f_12193_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)((Block)RegisterBlocks.FORGOTTEN_DUST_BLOCK.get()).m_49966_()));
            level.m_46747_(pos);
            level.m_7471_(pos, false);
        }
    }

    public boolean toggleActivity() {
        this.redstoneEnabled = !this.redstoneEnabled;
        this.m_6596_();
        return this.redstoneEnabled;
    }

    public int getDecayValue() {
        return this.decayValue;
    }

    public int getOrbValue() {
        return this.orbValue;
    }

    public int getSpawns() {
        return this.spawns;
    }

    public int countNeighborsOfType(int type, List<BlockPos> neighbors) {
        int count;
        block3: {
            Block extravagant;
            Level level;
            block2: {
                level = this.m_58904_();
                Block insightful = (Block)RegisterBlocks.INSIGHTFUL_AGAR.get();
                extravagant = (Block)RegisterBlocks.EXTRAVAGANT_AGAR.get();
                count = 0;
                if (type != 1) break block2;
                for (BlockPos pos : neighbors) {
                    if (level == null || !level.m_8055_(pos).m_60713_(insightful)) continue;
                    ++count;
                }
                break block3;
            }
            if (type != 2) break block3;
            for (BlockPos pos : neighbors) {
                if (level == null || !level.m_8055_(pos).m_60713_(extravagant)) continue;
                ++count;
            }
        }
        return Math.min(count, 6);
    }

    public double getTotalBonus(int type) {
        int faces = this.countNeighborsOfType(type, this.getAdjacents(this.m_58899_()));
        int edges = this.countNeighborsOfType(type, this.getEdgeBlocks(this.m_58899_()));
        int vertices = this.countNeighborsOfType(type, this.getVertexBlocks(this.m_58899_()));
        double faceBonus = (Double)Config.COMMON.agarFaceBonus.get();
        double edgeBonus = (Double)Config.COMMON.agarEdgeBonus.get();
        double vertexBonus = (Double)Config.COMMON.agarVertexBonus.get();
        return Math.pow(faceBonus, faces) * Math.pow(edgeBonus, edges) * Math.pow(vertexBonus, vertices);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.decayValue = tag.m_128451_("DecayValue");
        this.timeTillSpawn = tag.m_128451_("SpawnDelay");
        this.redstoneEnabled = tag.m_128471_("isRedstoneControllable");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("DecayValue", this.decayValue);
        tag.m_128405_("SpawnDelay", this.timeTillSpawn);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("DecayValue", this.decayValue);
        tag.m_128405_("SpawnDelay", this.timeTillSpawn);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

