/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.block_entities.ExperienceReceivingEntity;
import com.cyanogen.experienceobelisk.block_entities.bibliophage.bookshelves.AbstractInfectedBookshelfEntity;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.MiscUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AttunementStaffItem
extends Item {
    public AttunementStaffItem(Item.Properties p) {
        super(p);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && stack.m_150930_((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && stack.m_41784_().m_128441_("type")) {
            this.reset(stack);
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.unbind_obelisk"), true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity entity = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            if (entity instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)entity;
                this.handleObelisk(obelisk, stack, player);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (entity instanceof ExperienceReceivingEntity) {
                ExperienceReceivingEntity receiver = (ExperienceReceivingEntity)entity;
                this.handleExperienceReceivingBlock(receiver, stack, player, level);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (entity instanceof AbstractAcceleratorEntity) {
                AbstractAcceleratorEntity accelerator = (AbstractAcceleratorEntity)entity;
                this.handleAccelerator(accelerator, player);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (entity instanceof AbstractInfectedBookshelfEntity) {
                AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)entity;
                this.handleBookshelf(bookshelf, player);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6225_(context);
    }

    public void handleObelisk(ExperienceObeliskEntity obelisk, ItemStack stack, Player player) {
        BlockPos thisPos = obelisk.m_58899_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("boundX", thisPos.m_123341_());
        tag.m_128405_("boundY", thisPos.m_123342_());
        tag.m_128405_("boundZ", thisPos.m_123343_());
        tag.m_128359_("type", "obelisk");
        player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.bind_obelisk"), true);
    }

    public void handleExperienceReceivingBlock(ExperienceReceivingEntity receiver, ItemStack stack, Player player, Level level) {
        double range = (Double)Config.COMMON.bindingRange.get();
        BlockPos thisPos = receiver.m_58899_();
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128461_("type").equals("obelisk")) {
            BlockPos savedPos = new BlockPos(tag.m_128451_("boundX"), tag.m_128451_("boundY"), tag.m_128451_("boundZ"));
            BlockEntity savedEntity = level.m_7702_(savedPos);
            if (receiver.isBound && savedPos.equals((Object)receiver.getBoundPos())) {
                receiver.setUnbound();
                player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.unbind_target"), true);
            } else if (MiscUtils.straightLineDistance(thisPos, savedPos) <= range) {
                if (savedEntity instanceof ExperienceObeliskEntity) {
                    receiver.setBoundPos(savedPos);
                    player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.binding_wand.bind_target", (Object[])new Object[]{Component.m_237113_((String)savedPos.m_123344_()).m_130940_(ChatFormatting.GREEN)}), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.binding_wand.obelisk_doesnt_exist", (Object[])new Object[]{Component.m_237113_((String)savedPos.m_123344_())}).m_130940_(ChatFormatting.RED), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.obelisk_too_far"), true);
            }
        } else if (receiver.isBound) {
            receiver.setUnbound();
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.unbind_target"), true);
        }
    }

    public void handleAccelerator(AbstractAcceleratorEntity accelerator, Player player) {
        accelerator.toggleRedstoneEnabled();
        if (accelerator.redstoneEnabled) {
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.enable_redstone"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.disable_redstone"), true);
        }
    }

    public void handleBookshelf(AbstractInfectedBookshelfEntity bookshelf, Player player) {
        boolean status = bookshelf.toggleActivity();
        if (status) {
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.enable_redstone"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.binding_wand.disable_redstone"), true);
        }
    }

    public void reset(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("type");
        tag.m_128473_("boundX");
        tag.m_128473_("boundY");
        tag.m_128473_("boundZ");
    }
}

