/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.loot_modifiers;

import com.cyanogen.experienceobelisk.utils.MiscUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddSingleItem
extends LootModifier {
    public static final Codec<AddSingleItem> CODEC = RecordCodecBuilder.create(instance -> AddSingleItem.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("id").forGetter(o -> o.item), (App)Codec.FLOAT.fieldOf("appear_chance").forGetter(o -> Float.valueOf(o.appearChance)), (App)Codec.INT.fieldOf("min_quantity").forGetter(o -> o.min), (App)Codec.INT.fieldOf("max_quantity").forGetter(o -> o.max), (App)Codec.FLOAT.fieldOf("bias").forGetter(o -> Float.valueOf(o.bias)), (App)Codec.STRING.fieldOf("path").forGetter(o -> o.path))).apply((Applicative)instance, AddSingleItem::new));
    public final Item item;
    public final float appearChance;
    public final int min;
    public final int max;
    public final float bias;
    public final String path;

    public AddSingleItem(LootItemCondition[] conditionsIn, Item item, float appearChance, int min, int max, float bias, String path) {
        super(conditionsIn);
        this.item = item;
        this.appearChance = appearChance;
        this.min = min;
        this.max = max;
        this.bias = bias;
        this.path = path;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String contextPath = context.getQueriedLootTableId().m_135815_();
        if (contextPath.contains(this.path) && Math.random() <= (double)this.appearChance) {
            int count = MiscUtils.weightedRandInt(this.min, this.max, this.bias);
            for (int i = 0; i < count; ++i) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item, 1));
            }
            return generatedLoot;
        }
        return generatedLoot;
    }

    public Codec<AddSingleItem> codec() {
        return CODEC;
    }
}

