/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherRecipe
implements Recipe<SimpleContainer> {
    private final ArrayList<Tuple<Ingredient, Integer>> ingredients;
    private final ItemStack output;
    private final int cost;
    private final int processTime;
    private final ResourceLocation id;

    public MolecularMetamorpherRecipe(ArrayList<Tuple<Ingredient, Integer>> ingredients, ItemStack output, int cost, int processTime, ResourceLocation id) {
        this.ingredients = ingredients;
        this.output = output;
        this.cost = cost;
        this.processTime = processTime;
        this.id = id;
    }

    public static ArrayList<Tuple<Ingredient, Integer>> assembleIngredients(Ingredient ingredient1, int count1, Ingredient ingredient2, int count2, Ingredient ingredient3, int count3) {
        ArrayList<Tuple<Ingredient, Integer>> ingredients = new ArrayList<Tuple<Ingredient, Integer>>(4);
        ingredients.add(0, new Tuple((Object)Ingredient.f_43901_, (Object)0));
        ingredients.add(1, new Tuple((Object)ingredient1, (Object)count1));
        ingredients.add(2, new Tuple((Object)ingredient2, (Object)count2));
        ingredients.add(3, new Tuple((Object)ingredient3, (Object)count3));
        return ingredients;
    }

    public boolean matches(SimpleContainer container, @Nullable Level level) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (int j = 0; j < 3; ++j) {
            contents.add(container.m_8020_(j));
        }
        int tracker = 3;
        block1: for (int k = 1; k <= 3; ++k) {
            Ingredient ingredient = (Ingredient)this.ingredients.get(k).m_14418_();
            int count = (Integer)this.ingredients.get(k).m_14419_();
            if (ingredient.m_43947_() || count <= 0) {
                --tracker;
                continue;
            }
            if (contents.isEmpty()) continue;
            for (ItemStack item : contents) {
                if (!ingredient.test(item) || item.m_41613_() < count) continue;
                --tracker;
                contents.remove(item);
                continue block1;
            }
        }
        return tracker <= 0;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (Tuple<Ingredient, Integer> ingredient : this.ingredients) {
            list.add((Object)((Ingredient)ingredient.m_14418_()));
        }
        return list;
    }

    public ArrayList<Tuple<Ingredient, Integer>> getIngredients(boolean k) {
        return this.ingredients;
    }

    public ItemStack assemble(SimpleContainer container, @Nullable RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getCost() {
        return this.cost;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean isNameFormatting() {
        return this.id.m_135815_().equals("item_name_formatting");
    }

    public String getInfo() {
        return "----- Molecular Metamorphosis ----- \nID: " + this.id + "\nIngredients: \n" + this.getIngredientInfoString() + "Output: " + this.output + "\nCost: " + this.cost + "\nProcess Time: " + this.processTime + "\n";
    }

    public String getIngredientInfoString() {
        StringBuilder info = new StringBuilder();
        for (Tuple<Ingredient, Integer> ingredient : this.ingredients) {
            if (((Ingredient)ingredient.m_14418_()).m_43947_() || (Integer)ingredient.m_14419_() <= 0) continue;
            ItemStack first = ((Ingredient)ingredient.m_14418_()).m_43908_()[0];
            int count = (Integer)ingredient.m_14419_();
            info.append(count).append("- ").append(first.m_41720_());
            if (((Ingredient)ingredient.m_14418_()).m_43908_().length > 1) {
                info.append(" etc...");
            }
            info.append("\n");
        }
        return info.toString();
    }

    public static class Serializer
    implements RecipeSerializer<MolecularMetamorpherRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("experienceobelisk", "molecular_metamorphosis");

        public MolecularMetamorpherRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient1"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient2"));
            Ingredient ingredient3 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient3"));
            int count1 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count1");
            int count2 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count2");
            int count3 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count3");
            ArrayList<Tuple<Ingredient, Integer>> ingredients = MolecularMetamorpherRecipe.assembleIngredients(ingredient1, count1, ingredient2, count2, ingredient3, count3);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipe, (String)"result"));
            int cost = GsonHelper.m_13927_((JsonObject)recipe, (String)"cost");
            int processTime = GsonHelper.m_13927_((JsonObject)recipe, (String)"processTime");
            return new MolecularMetamorpherRecipe(ingredients, result, cost, processTime, id);
        }

        @Nullable
        public MolecularMetamorpherRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count1 = buffer.readInt();
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count2 = buffer.readInt();
            Ingredient ingredient3 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count3 = buffer.readInt();
            ArrayList<Tuple<Ingredient, Integer>> ingredients = MolecularMetamorpherRecipe.assembleIngredients(ingredient1, count1, ingredient2, count2, ingredient3, count3);
            ItemStack result = buffer.m_130267_();
            int cost = buffer.readInt();
            int processTime = buffer.readInt();
            return new MolecularMetamorpherRecipe(ingredients, result, cost, processTime, id);
        }

        public void toNetwork(FriendlyByteBuf buffer, MolecularMetamorpherRecipe recipe) {
            for (int i = 1; i <= 3; ++i) {
                ((Ingredient)recipe.ingredients.get(i).m_14418_()).m_43923_(buffer);
                buffer.writeInt(((Integer)recipe.ingredients.get(i).m_14419_()).intValue());
            }
            buffer.writeItemStack(recipe.m_8043_(null), false);
            buffer.writeInt(recipe.cost);
            buffer.writeInt(recipe.processTime);
        }
    }

    public static class Type
    implements RecipeType<MolecularMetamorpherRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "molecular_metamorphosis";
    }
}

