/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.recipe.EmptyingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EmptyingCategory
implements IRecipeCategory<EmptyingRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    public final ResourceLocation emptyingBackground = new ResourceLocation("experienceobelisk:textures/gui/recipes/emptying_jei.png");
    public final ResourceLocation cognitiumTexture = new ResourceLocation("experienceobelisk:textures/block/cognitium.png");
    public final IDrawableAnimated arrow;
    public final IDrawable cognitiumStack;
    private final int arrowWidth = 41;
    private final int arrowHeight = 7;
    private final int arrowOffsetX = 35;
    private final int arrowOffsetY = 21;
    private final int cognitiumOffsetX = 110;
    private final int cognitiumOffsetY = 18;
    public static final RecipeType<EmptyingRecipe> EMPTYING_TYPE = RecipeType.create((String)"experienceobelisk", (String)"emptying", EmptyingRecipe.class);

    public EmptyingCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.emptyingBackground, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.cognitiumStack = this.guiHelper.drawableBuilder(this.cognitiumTexture, 0, 0, 16, 16).build();
    }

    public RecipeType<EmptyingRecipe> getRecipeType() {
        return EMPTYING_TYPE;
    }

    public int getWidth() {
        return 136;
    }

    public int getHeight() {
        return 66;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.experienceobelisk.emptying.title");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.emptyingBackground, 0, 0, 136, 66);
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(EmptyingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 35, 21);
        if (recipe.getCognitiumGain() > 0) {
            this.cognitiumStack.draw(guiGraphics, 110, 18);
        }
    }

    public List<Component> getTooltipStrings(EmptyingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.getArrowTooltip(tooltip, mouseX, mouseY);
        this.getCognitiumTooltip(recipe.getCognitiumGain(), tooltip, mouseX, mouseY);
        return tooltip;
    }

    public void getArrowTooltip(List<Component> components, double mouseX, double mouseY) {
        MutableComponent arrowTooltip = Component.m_237115_((String)"jei.experienceobelisk.emptying.tooltip");
        int x1 = 32;
        int x2 = 79;
        int y1 = 19;
        int y2 = 30;
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            components.add((Component)arrowTooltip);
        }
    }

    public void getCognitiumTooltip(int cognitiumGain, List<Component> components, double mouseX, double mouseY) {
        int x1 = 110;
        int x2 = x1 + 16;
        int y1 = 18;
        int y2 = y1 + 16;
        if (cognitiumGain > 0 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            int xp = cognitiumGain / 20;
            int levels = ExperienceUtils.xpToLevels(xp);
            MutableComponent volumeComponent = Component.m_237110_((String)"jei.experienceobelisk.shared.cognitium_amount.mb", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(cognitiumGain)).m_130940_(ChatFormatting.GREEN)});
            MutableComponent xpLevelsComponent = Component.m_237110_((String)"jei.experienceobelisk.shared.cognitium_amount.levels_xp", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(levels)).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(xp)).m_130940_(ChatFormatting.GREEN)});
            components.add((Component)volumeComponent);
            components.add((Component)xpLevelsComponent);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyingRecipe recipe, IFocusGroup focuses) {
        ItemStack catalyst = ((Item)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()).m_7968_();
        ItemStack result = ItemStack.f_41583_;
        if (recipe.hasResultStack()) {
            result = recipe.m_8043_(null);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setSlotName("input").addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 47, 34).setSlotName("catalyst").addItemStack(catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 18).setSlotName("output").addItemStack(result);
    }
}

