/*
 * Decompiled with CFR 0.152.
 */
package net.tethermod;

import com.mojang.serialization.Codec;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import net.tethermod.TetherHelper;
import net.tethermod.TetherItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TetherMod
implements ModInitializer {
    public static final String MOD_ID = "tethermod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tethermod");
    public static MinecraftServer SERVER;
    private final Deque<class_1657> playerQueue = new ArrayDeque<class_1657>();
    public static final class_2400 DAMAGE_BOUNCE_PARTICLE;
    public static final class_3414 DAMAGE_BOUNCE_SOUND_EVENT;
    public static class_1792 TETHER;
    public static final AttachmentType<class_2338> LAST_BLOCK_TYPE;
    public static final AttachmentType<UUID> TETHER_UUID_TYPE;
    public static final AttachmentType<Integer> TETHER_DAMAGE_BOUNCES_TYPE;
    public static final class_9331<List<UUID>> TETHER_UUIDS;

    private static class_2400 registerParticle(String name, class_2400 particleType) {
        return (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)name), (Object)particleType);
    }

    private static class_3414 registerSoundEvent(String name) {
        class_2960 id = class_2960.method_60655((String)MOD_ID, (String)name);
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
    }

    private static class_1792 registerItem(String name, Function<class_1792.class_1793, class_1792> function) {
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)name), (Object)function.apply(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)MOD_ID, (String)name)))));
    }

    private static <T> class_9331<T> registerComponentType(class_2960 id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public void onInitialize() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(fabricItemGroupEntries -> fabricItemGroupEntries.method_45421((class_1935)TETHER));
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            SERVER = minecraftServer;
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, sender, minecraftServer) -> {
            SERVER = minecraftServer;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() == TETHER) {
                UUID uuid = entity.method_5667();
                TetherHelper.update((class_1297)player, entity, itemStack, uuid);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, damageSource, amount) -> {
            class_1297 protector;
            UUID uuid = (UUID)entity.getAttached(TETHER_UUID_TYPE);
            if (uuid != null && (protector = TetherHelper.getEntityFromUuid(uuid)) != null && protector instanceof class_1657) {
                class_1657 playerEntity = (class_1657)protector;
                class_1661 playerInventory = playerEntity.method_31548();
                Iterable iter = () -> Stream.concat(playerInventory.method_67533().stream(), Stream.of(playerEntity.method_6079())).iterator();
                for (class_1799 itemStack : iter) {
                    Boolean hasUuid;
                    if (itemStack.method_7909() != TETHER || !(hasUuid = TetherHelper.has(itemStack, entity.method_5667())).booleanValue()) continue;
                    class_3218 serverWorld = (class_3218)entity.method_37908();
                    serverWorld.method_65096((class_2394)DAMAGE_BOUNCE_PARTICLE, entity.method_23317(), entity.method_23320(), entity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                    entity.method_5783(DAMAGE_BOUNCE_SOUND_EVENT, 1.0f, 0.0f);
                    if (damageSource.method_49708(class_8111.field_42347)) {
                        if (!(entity.method_6032() <= 15.0f)) continue;
                        class_2338 lastPos = (class_2338)entity.getAttached(LAST_BLOCK_TYPE);
                        if (serverWorld.field_9236) continue;
                        entity.field_6017 = 0.0;
                        if (lastPos != null) {
                            entity.method_48105(serverWorld, (double)((float)lastPos.method_10263() - 0.5f), (double)((float)lastPos.method_10264() - 0.5f), (double)((float)lastPos.method_10260() - 0.5f), class_2709.field_54094, entity.method_36454(), entity.method_36455(), true);
                        } else {
                            entity.method_48105(serverWorld, protector.method_23317(), protector.method_23318(), protector.method_23321(), class_2709.field_54094, entity.method_36454(), entity.method_36455(), true);
                        }
                        TetherHelper.applyDamage(protector, damageSource, Float.valueOf(Float.POSITIVE_INFINITY));
                        continue;
                    }
                    if (TetherHelper.applyDamage(protector, damageSource, Float.valueOf(amount))) continue;
                    return false;
                }
            }
            return true;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.playerQueue.isEmpty()) {
                this.playerQueue.addAll(server.method_3760().method_14571());
            } else {
                class_1657 playerEntity = this.playerQueue.pollFirst();
                if (playerEntity != null && !playerEntity.method_31481() && playerEntity.method_24828()) {
                    playerEntity.setAttached(LAST_BLOCK_TYPE, (Object)playerEntity.method_24515());
                }
            }
        });
    }

    static {
        DAMAGE_BOUNCE_PARTICLE = TetherMod.registerParticle("damage_bounce", FabricParticleTypes.simple());
        DAMAGE_BOUNCE_SOUND_EVENT = TetherMod.registerSoundEvent("damage_bounce");
        TETHER = TetherMod.registerItem("tether", TetherItem::new);
        LAST_BLOCK_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"last_block"), builder -> builder.persistent(class_2338.field_25064).initializer(() -> null));
        TETHER_UUID_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"tether_uuid"), builder -> builder.persistent(class_4844.field_40825).initializer(() -> null));
        TETHER_DAMAGE_BOUNCES_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"tether_damage_initiator"), builder -> builder.persistent((Codec)Codec.INT).initializer(() -> null));
        TETHER_UUIDS = TetherMod.registerComponentType(class_2960.method_60655((String)MOD_ID, (String)"tether_uuid_list"), builder -> builder.method_57881(Codec.list((Codec)class_4844.field_40825)));
    }
}

