/*
 * Decompiled with CFR 0.152.
 */
package net.tethermod;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import net.tethermod.TetherHelper;
import net.tethermod.TetherItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TetherMod
implements ModInitializer {
    public static final String MOD_ID = "tethermod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tethermod");
    public static MinecraftServer SERVER;
    private List<class_1657> playerList = new ArrayList<class_1657>();
    public static class_1792 TETHER;
    public static final AttachmentType<class_2338> LAST_BLOCK_TYPE;
    public static final AttachmentType<UUID> TETHER_UUID_TYPE;
    public static final AttachmentType<Integer> TETHER_DAMAGE_BOUNCES_TYPE;
    public static final class_9331<List<UUID>> TETHER_UUIDS;

    private static class_1792 registerItem(String name, Function<class_1792.class_1793, class_1792> function) {
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)name), (Object)function.apply(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)MOD_ID, (String)name)))));
    }

    private static <T> class_9331<T> registerComponentType(class_2960 id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public void onInitialize() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(fabricItemGroupEntries -> fabricItemGroupEntries.method_45421((class_1935)TETHER));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SERVER = server;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7909() == TETHER) {
                UUID uuid = entity.method_5667();
                TetherHelper.update((class_1297)player, entity, itemStack, uuid);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, damageSource, amount) -> {
            class_1297 protector;
            UUID uuid = (UUID)entity.getAttached(TETHER_UUID_TYPE);
            if (uuid != null && (protector = TetherHelper.getEntityFromUuid(uuid)) != null && protector.method_31747()) {
                class_1657 playerEntity = (class_1657)protector;
                for (class_1799 itemStack : playerEntity.method_31548()) {
                    Boolean hasUuid;
                    if (itemStack.method_7909() != TETHER || !(hasUuid = TetherHelper.has(itemStack, entity.method_5667())).booleanValue()) continue;
                    if (damageSource.method_49708(class_8111.field_42347)) {
                        if (!(entity.method_6032() <= 7.0f)) continue;
                        class_2338 lastPos = (class_2338)entity.getAttached(LAST_BLOCK_TYPE);
                        class_3218 serverWorld = (class_3218)protector.method_37908();
                        if (serverWorld.field_9236) continue;
                        entity.field_6017 = 0.0;
                        if (lastPos != null) {
                            entity.method_6082((double)lastPos.method_10263(), (double)lastPos.method_10264(), (double)lastPos.method_10260(), false);
                        } else {
                            entity.method_48105(serverWorld, protector.method_23317(), protector.method_23318(), protector.method_23321(), class_2709.field_54094, entity.method_36454(), entity.method_36455(), true);
                        }
                        protector.method_64397(serverWorld, damageSource, Float.POSITIVE_INFINITY);
                        continue;
                    }
                    Integer bounces = (Integer)protector.getAttached(TETHER_DAMAGE_BOUNCES_TYPE);
                    if (bounces == null) {
                        protector.setAttached(TETHER_DAMAGE_BOUNCES_TYPE, (Object)0);
                    }
                    if (bounces < 4) {
                        protector.setAttached(TETHER_DAMAGE_BOUNCES_TYPE, (Object)(bounces + 1));
                        protector.method_64397((class_3218)entity.method_37908(), damageSource, amount);
                        protector.setAttached(TETHER_DAMAGE_BOUNCES_TYPE, (Object)0);
                        return false;
                    }
                    protector.setAttached(TETHER_DAMAGE_BOUNCES_TYPE, (Object)0);
                }
            }
            return true;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.playerList.isEmpty()) {
                for (class_1657 player : server.method_3760().method_14571()) {
                    this.playerList.add(player);
                }
            } else {
                class_1657 playerEntity = this.playerList.getFirst();
                if (!playerEntity.method_31481() && playerEntity.method_24828()) {
                    playerEntity.setAttached(LAST_BLOCK_TYPE, (Object)playerEntity.method_24515());
                }
                this.playerList.removeFirst();
            }
        });
    }

    static {
        TETHER = TetherMod.registerItem("tether", TetherItem::new);
        LAST_BLOCK_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"last_block"), builder -> builder.persistent(class_2338.field_25064).initializer(() -> new class_2338(0, 0, 0)));
        TETHER_UUID_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"tether_uuid"), builder -> builder.persistent(class_4844.field_40825).initializer(() -> null));
        TETHER_DAMAGE_BOUNCES_TYPE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"tether_damage_initiator"), builder -> builder.persistent((Codec)Codec.INT).initializer(() -> null));
        TETHER_UUIDS = TetherMod.registerComponentType(class_2960.method_60655((String)MOD_ID, (String)"tether_uuid"), builder -> builder.method_57881(Codec.list((Codec)class_4844.field_40825)));
    }
}

