/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan.undefeatables.blacklist;

import com.baranhan.undefeatables.Main;
import com.baranhan.undefeatables.blacklist.BlacklistEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class BlacklistRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/undefeatables/blacklist");
    public static BlacklistEntry blacklist_entry;

    public static void loadResourceEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            String[] entities = new String[]{"minecraft:pig", "minecraft:cow"};
            blacklist_entry = new BlacklistEntry(entities);
            try (FileWriter writer = new FileWriter(new File(JSON_DIR, "mob_blacklist.json"));){
                GSON.toJson((Object)blacklist_entry, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    BlacklistEntry entry = (BlacklistEntry)GSON.fromJson((Reader)json, BlacklistEntry.class);
                    if (entry != null) {
                        blacklist_entry = entry;
                        continue;
                    }
                    Main.LOGGER.error("Could not load undefeatable entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the undefeatable config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

