/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan.undefeatables.customdrops;

import com.baranhan.undefeatables.Main;
import com.baranhan.undefeatables.customdrops.CustomDropsEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class CustomDropsRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/undefeatables/customdrops");
    public static CustomDropsEntry custom_drops_entry;

    public static void loadResourceEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            String[] items1 = new String[]{"minecraft:iron_ingot:0-15:0-350", "minecraft:diamond:17-28:0-350"};
            String[] items2 = new String[]{"minecraft:iron_ingot:0-15:0-350"};
            String[] items3 = new String[]{"minecraft:iron_ingot:0-15:0-350"};
            String[] items4 = new String[]{"minecraft:iron_ingot:0-15:0-350"};
            custom_drops_entry = new CustomDropsEntry(items1, items2, items3, items4);
            try (FileWriter writer = new FileWriter(new File(JSON_DIR, "custom_drops.json"));){
                GSON.toJson((Object)custom_drops_entry, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    CustomDropsEntry entry = (CustomDropsEntry)GSON.fromJson((Reader)json, CustomDropsEntry.class);
                    if (entry != null) {
                        custom_drops_entry = entry;
                        continue;
                    }
                    Main.LOGGER.error("Could not load undefeatable entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the undefeatable config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

