/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan.undefeatables.customnames;

import com.baranhan.undefeatables.Main;
import com.baranhan.undefeatables.customnames.CustomNamesEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class CustomNamesRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File JSON_DIR = new File(FMLPaths.CONFIGDIR.get().toFile() + "/undefeatables/customnames");
    public static CustomNamesEntry custom_names_entry;

    public static void loadResourceEntries() {
        if (!JSON_DIR.exists()) {
            JSON_DIR.mkdirs();
            String[] name = new String[]{"Mark:the Glutton"};
            custom_names_entry = new CustomNamesEntry(name);
            try (FileWriter writer = new FileWriter(new File(JSON_DIR, "custom_names.json"));){
                GSON.toJson((Object)custom_names_entry, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        for (File file : JSON_DIR.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    CustomNamesEntry entry = (CustomNamesEntry)GSON.fromJson((Reader)json, CustomNamesEntry.class);
                    if (entry != null) {
                        custom_names_entry = entry;
                        continue;
                    }
                    Main.LOGGER.error("Could not load undefeatable entry from {}.", (Object)fileName);
                }
                catch (Exception e) {
                    Main.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                    Main.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Main.LOGGER.error("Found invalid file {} in the undefeatable config folder. It must be a .json file!", (Object)fileName);
        }
    }
}

