/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum;

import java.util.Objects;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.utils.ConfigUtils;
import net.borisshoes.borislib.utils.TextUtils;

public class ArcanaConfig {
    public static int getInt(ConfigSetting<?> setting) {
        try {
            return (Integer)ArcanaNovum.CONFIG.getValue(setting.getName());
        }
        catch (Exception e) {
            ArcanaNovum.log(3, "Failed to get Integer config for " + setting.getName());
            ArcanaNovum.log(3, e.toString());
            return 0;
        }
    }

    public static boolean getBoolean(ConfigSetting<?> setting) {
        try {
            return (Boolean)ArcanaNovum.CONFIG.getValue(setting.getName());
        }
        catch (Exception e) {
            ArcanaNovum.log(3, "Failed to get Boolean config for " + setting.getName());
            ArcanaNovum.log(3, e.toString());
            return false;
        }
    }

    public static interface ConfigSetting<T> {
        public ConfigUtils.IConfigValue<T> makeConfigValue();

        public String getId();

        public String getName();
    }

    public record XPConfigSetting(Integer defaultValue, String name, String description, boolean capConfig) implements ConfigSetting<Integer>
    {
        public XPConfigSetting(int defaultValue, String name, String description) {
            this(defaultValue, name, description, false);
        }

        public XPConfigSetting(Integer defaultValue, String name, String description, boolean capConfig) {
            this.defaultValue = Objects.requireNonNullElse(defaultValue, 1);
            this.name = Objects.requireNonNullElse(name, "");
            this.description = Objects.requireNonNullElse(description, "");
            this.capConfig = capConfig;
        }

        public String configGetSet(boolean setter) {
            return (this.capConfig ? "Max XP for " : "XP for ") + this.description + (setter ? " is now: %s" : " is: %s");
        }

        @Override
        public ConfigUtils.IConfigValue<Integer> makeConfigValue() {
            return new ConfigUtils.IntegerConfigValue("xp" + this.name, this.defaultValue, new ConfigUtils.IntegerConfigValue.IntLimits(0, 100000), (this.capConfig ? "The max XP given for " : "The XP given for ") + this.description, new ConfigUtils.Command(this.configGetSet(false), this.configGetSet(true)));
        }

        @Override
        public String getId() {
            return TextUtils.camelToSnake((String)("xp" + this.name));
        }

        @Override
        public String getName() {
            return "xp" + this.name;
        }
    }

    public record NormalConfigSetting<T>(ConfigUtils.IConfigValue<T> setting) implements ConfigSetting<T>
    {
        public NormalConfigSetting(ConfigUtils.IConfigValue<T> setting) {
            this.setting = Objects.requireNonNull(setting);
        }

        @Override
        public ConfigUtils.IConfigValue<T> makeConfigValue() {
            return this.setting;
        }

        @Override
        public String getId() {
            return TextUtils.camelToSnake((String)this.setting.getName());
        }

        @Override
        public String getName() {
            return this.setting.getName();
        }
    }
}

