/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.achievements;

import java.text.DecimalFormat;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class ProgressAchievement
extends ArcanaAchievement {
    private int goal;
    private int progress = 0;

    public ProgressAchievement(String name, String id, class_1799 displayItem, ArcanaItem arcanaItem, int xpReward, int pointsReward, String[] description, int goal) {
        super(name, id, 1, displayItem, arcanaItem, xpReward, pointsReward, description);
        this.goal = goal;
        this.setAcquired(false);
    }

    protected int getProgress() {
        return this.progress;
    }

    protected boolean setProgress(int progress) {
        boolean had = this.isAcquired();
        this.progress = class_3532.method_15340((int)progress, (int)0, (int)this.goal);
        this.setAcquired(this.progress >= this.goal);
        return this.isAcquired() && !had;
    }

    protected int getGoal() {
        return this.goal;
    }

    protected void setGoal(int goal) {
        this.goal = goal;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("acquired", this.isAcquired());
        nbt.method_10582("name", this.name);
        nbt.method_10569("type", this.type);
        nbt.method_10569("progress", this.progress);
        nbt.method_10569("goal", this.goal);
        return nbt;
    }

    @Override
    public ProgressAchievement fromNbt(String id, class_2487 nbt) {
        ProgressAchievement ach = (ProgressAchievement)ArcanaAchievements.registry.get(id).makeNew();
        ach.setProgress(nbt.method_68083("progress", 0));
        ach.setAcquired(nbt.method_68566("acquired", false));
        return ach;
    }

    @Override
    public class_5250[] getStatusDisplay(class_3222 player) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        ProgressAchievement achievement = (ProgressAchievement)profile.getAchievement(this.getArcanaItem().getId(), this.id);
        class_5250[] text = new class_5250[achievement != null && achievement.isAcquired() ? 2 : 1];
        DecimalFormat df = new DecimalFormat("##0.00");
        double percent = 100.0 * (double)(achievement == null ? 0 : achievement.getProgress()) / (double)this.goal;
        text[0] = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Progress: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(achievement == null ? Integer.valueOf(0) : LevelUtils.readableInt(achievement.getProgress()))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(this.goal)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(df.format(percent) + "%")).method_27692(class_124.field_1078));
        if (achievement != null && achievement.isAcquired()) {
            text[1] = class_2561.method_43470((String)"Achieved!").method_27692(class_124.field_1075);
        }
        return text;
    }

    @Override
    public ProgressAchievement makeNew() {
        return new ProgressAchievement(this.name, this.id, this.getDisplayItem(), this.getArcanaItem(), this.xpReward, this.pointsReward, this.getDescription(), this.goal);
    }
}

