/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.areaeffects;

import java.util.ArrayList;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.areaeffects.AreaEffectSource;
import net.borisshoes.arcananovum.areaeffects.AreaEffectTracker;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SmokeArrowAreaEffectTracker
extends AreaEffectTracker {
    private final List<SmokeArrowSource> sources = new ArrayList<SmokeArrowSource>();

    public SmokeArrowAreaEffectTracker() {
        super("smoke_arrow");
    }

    @Override
    public void onTick(MinecraftServer server) {
        if (this.sources.isEmpty()) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            ArrayList<class_2338> affectedBlocks = new ArrayList<class_2338>();
            for (SmokeArrowSource source : this.sources) {
                affectedBlocks.addAll(source.getAffectedBlocks(world).stream().filter(blockPos -> affectedBlocks.stream().noneMatch(block -> block.equals(blockPos))).toList());
                source.affectEntities(world);
            }
            for (class_2338 block : affectedBlocks) {
                ArcanaEffectUtils.smokeArrowEmit(world, block.method_46558());
            }
        }
        this.sources.removeIf(SmokeArrowSource::age);
    }

    @Override
    public void addSource(AreaEffectSource source) {
        if (source instanceof SmokeArrowSource) {
            SmokeArrowSource smokeSource = (SmokeArrowSource)source;
            this.sources.add(smokeSource);
        }
    }

    public static SmokeArrowSource source(@Nullable class_1297 contributor, @Nullable class_1297 sourceEntity, @Nullable class_2338 sourceBlock, @Nullable class_3218 blockWorld, double range, int gasLvl) {
        return new SmokeArrowSource(sourceEntity, sourceBlock, blockWorld, range, gasLvl, contributor);
    }

    public static class SmokeArrowSource
    extends AreaEffectSource {
        private final class_1297 sourceEntity;
        private final class_2338 sourceBlock;
        private final class_3218 blockWorld;
        private final double range;
        private final int gasLvl;
        private final boolean fromEntity;
        private int age;
        private final int duration;
        private final class_1297 contributor;

        private SmokeArrowSource(@Nullable class_1297 sourceEntity, @Nullable class_2338 sourceBlock, @Nullable class_3218 blockWorld, double range, int gasLvl, @Nullable class_1297 contributor) {
            this.sourceEntity = sourceEntity;
            this.sourceBlock = sourceBlock;
            this.blockWorld = blockWorld;
            this.range = range;
            this.gasLvl = gasLvl;
            this.fromEntity = sourceEntity != null;
            this.contributor = contributor;
            this.age = 0;
            this.duration = 100;
        }

        public class_1937 getSourceWorld() {
            if (this.fromEntity) {
                return this.sourceEntity.method_37908();
            }
            return this.blockWorld;
        }

        public class_2338 getBlockPos() {
            if (this.fromEntity) {
                return this.sourceEntity.method_24515();
            }
            return this.sourceBlock;
        }

        public boolean age() {
            ++this.age;
            return this.age >= this.duration;
        }

        public int getGasLvl() {
            return this.gasLvl;
        }

        public class_1297 getContributor() {
            return this.contributor;
        }

        public void affectEntities(class_3218 world) {
            if (this.age % 5 != 0) {
                return;
            }
            int mobCount = 0;
            boolean withOwner = false;
            for (class_1297 affectedEntity : this.getAffectedEntities(world)) {
                class_3222 player;
                class_1297 class_12972;
                if (!(affectedEntity instanceof class_1309)) continue;
                class_1309 e = (class_1309)affectedEntity;
                int amp = e instanceof class_1308 ? 5 : 0;
                class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, 60 * (this.gasLvl + 1), 7, false, false, true);
                class_1293 weakness = new class_1293(class_1294.field_5911, 60 * (this.gasLvl + 1), amp + this.gasLvl, false, false, true);
                class_1293 invis = new class_1293(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT, 60 * (this.gasLvl + 1), 0, false, false, true);
                e.method_6092(blind);
                e.method_6092(weakness);
                if (e instanceof class_3222) {
                    e.method_6092(invis);
                }
                if (e instanceof class_1588) {
                    class_1588 mob = (class_1588)e;
                    mob.method_19540(false);
                    mob.method_6015(null);
                    ++mobCount;
                }
                if (!((class_12972 = this.contributor) instanceof class_3222) || !(player = (class_3222)class_12972).method_5667().equals(e.method_5667())) continue;
                withOwner = true;
            }
            class_1297 class_12973 = this.contributor;
            if (class_12973 instanceof class_3222) {
                class_3222 player = (class_3222)class_12973;
                if (withOwner && mobCount >= 3) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.SMOKE_SCREEN.id);
                }
            }
            SoundUtils.playSound((class_1937)world, (class_2338)this.getBlockPos(), (class_3414)class_3417.field_17483, (class_3419)class_3419.field_15248, (float)0.5f, (float)1.0f);
        }

        @Override
        public List<class_2338> getAffectedBlocks(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().method_29177().toString().equals(world.method_27983().method_29177().toString())) {
                ArrayList<class_2338> blocks = new ArrayList<class_2338>();
                for (class_2338 block : class_2338.method_25996((class_2338)this.getBlockPos(), (int)((int)this.range + 4), (int)((int)this.range + 4), (int)((int)this.range + 4))) {
                    if (!(block.method_46558().method_1022(this.getBlockPos().method_46558()) <= this.range + 2.0)) continue;
                    blocks.add((class_2338)block.method_25503());
                }
                return blocks;
            }
            return new ArrayList<class_2338>();
        }

        @Override
        public List<class_1297> getAffectedEntities(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().method_29177().toString().equals(world.method_27983().method_29177().toString())) {
                class_2338 blockPos = this.getBlockPos();
                class_238 rangeBox = class_238.method_29968((class_243)blockPos.method_46558()).method_1014(this.range + 4.0);
                return world.method_8333(null, rangeBox, e -> !e.method_7325() && e.method_5707(blockPos.method_46558()) < 4.0 * this.range * this.range && e instanceof class_1309);
            }
            return new ArrayList<class_1297>();
        }

        @Override
        public int getDuration() {
            return this.duration;
        }
    }
}

