/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.ContinuumAnchorBlockEntity;
import net.borisshoes.arcananovum.cardinalcomponents.IAnchorsComponent;
import net.borisshoes.arcananovum.cardinalcomponents.WorldDataComponentInitializer;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ContinuumAnchor
extends ArcanaBlock {
    public static final int RANGE = 2;
    public static final String ID = "continuum_anchor";

    public ContinuumAnchor() {
        this.id = ID;
        this.name = "Continuum Anchor";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_23141;
        this.block = new ContinuumAnchorBlock(this, class_4970.class_2251.method_9637().method_31710(class_3620.field_16009).method_29292().method_9629(50.0f, 1200.0f).method_9631(state -> ContinuumAnchorBlock.getLightLevel(state, 15)));
        this.item = new ContinuumAnchorItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.continuum_anchor", (String)this.name).method_27692(class_124.field_1067).method_54663(1387734);
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.UNLOCK_EXOTIC_MATTER, ResearchTasks.ADVANCEMENT_CHARGE_RESPAWN_ANCHOR, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"continuum anchor").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)" has the extraordinary ability to manipulate ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"spacetime").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It just needs the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"right type").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"fuel").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"continuum anchor").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)" consumes ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"exotic matter").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"chunk load").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"5x5 area").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"area ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"also receives ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"random ticks").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" and keeps ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"mobs ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"loaded").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public static void loadChunks(class_3218 serverWorld, class_1923 pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                ContinuumAnchor.addChunk(serverWorld, new class_1923(pos.field_9181 + i, pos.field_9180 + j));
            }
        }
    }

    public static void addChunk(class_3218 world, class_1923 chunk) {
        world.method_14178().method_66009(ArcanaRegistry.ANCHOR_TICKET_TYPE, chunk, 2);
        Long2IntOpenHashMap m = ArcanaNovum.ANCHOR_CHUNKS.computeIfAbsent(world, w -> new Long2IntOpenHashMap());
        m.put(chunk.method_8324(), 40);
    }

    public static boolean isChunkLoaded(class_3218 serverWorld, class_1923 chunk) {
        return ArcanaNovum.ANCHOR_CHUNKS.getOrDefault(serverWorld, new Long2IntOpenHashMap()).containsKey(chunk.method_8324());
    }

    public static void updateLoadedChunks(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            Long2IntOpenHashMap chunks = ArcanaNovum.ANCHOR_CHUNKS.get(world);
            if (chunks == null || chunks.isEmpty()) continue;
            boolean nonEmpty = false;
            ObjectIterator it = chunks.long2IntEntrySet().fastIterator();
            while (it.hasNext()) {
                Long2IntMap.Entry e = (Long2IntMap.Entry)it.next();
                int t = e.getIntValue();
                if (t <= 1) {
                    it.remove();
                    continue;
                }
                e.setValue(t - 1);
                nonEmpty = true;
            }
            if (!nonEmpty) continue;
            world.method_14197();
        }
    }

    public static void initLoadedChunks(MinecraftServer minecraftServer) {
        for (class_3218 serverWorld : minecraftServer.method_3738()) {
            for (class_2338 anchorPos : ((IAnchorsComponent)WorldDataComponentInitializer.ACTIVE_ANCHORS.get((Object)serverWorld)).getAnchors()) {
                class_1923 chunkPos = new class_1923(anchorPos);
                ContinuumAnchor.loadChunks(serverWorld, chunkPos);
            }
        }
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Continuum Anchor").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nExotic Matter has given useful insight into warping spacetime. On top of being more practiced in constructing study casing that can channel Arcana, I have made additional efforts to reinforce").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Continuum Anchor").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nthis chassis against dimensional shear. By combining all known techniques of manipulating dimensional energy, I believe I can cause a section of space to be locked in time so that the world cannot be unloaded.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Continuum Anchor").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nWhen fed with Exotic Matter, the Anchor chunk loads a 5x5 chunk area and produces lazy chunks in the 7x7 ring around it. \nIt is able to stimulate mobs such that they despawn slower when a player isn\u2019t nearby,").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Continuum Anchor").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nwhile also inducing new spawns and activating spawners.\nThe Anchor can be turned off with a redstone signal and its fuel can be removed by an empty hand. Additional fuel may also be added while still in use.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22020, 2);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_23141, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8449, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore());
    }

    public class ContinuumAnchorBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2758 CHARGES = class_2741.field_23187;
        public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");

        public ContinuumAnchorBlock(ContinuumAnchor this$0, class_4970.class_2251 settings) {
            super(this$0.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return (class_2680)class_2246.field_23152.method_9564().method_11657((class_2769)CHARGES, (Comparable)((Integer)state.method_11654((class_2769)CHARGES)));
        }

        @Nullable
        public static ContinuumAnchorBlockEntity getEntity(class_1937 world, class_2338 pos) {
            ContinuumAnchorBlockEntity anchor;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof ContinuumAnchorBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof ContinuumAnchorBlockEntity ? (anchor = (ContinuumAnchorBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new ContinuumAnchorBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return ContinuumAnchorBlock.method_31618(type, ArcanaRegistry.CONTINUUM_ANCHOR_BLOCK_ENTITY, ContinuumAnchorBlockEntity::ticker);
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CHARGES, (Comparable)Integer.valueOf(0));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{CHARGES, ACTIVE});
        }

        protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            ContinuumAnchorBlockEntity anchor = (ContinuumAnchorBlockEntity)world.method_8321(pos);
            if (anchor != null && anchor.interact(player, stack)) {
                return class_1269.field_52422;
            }
            return class_1269.field_52423;
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
            ContinuumAnchorBlockEntity anchor = (ContinuumAnchorBlockEntity)world.method_8321(pos);
            if (anchor != null && anchor.interact(player, class_1799.field_8037)) {
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof ContinuumAnchorBlockEntity) {
                ContinuumAnchorBlockEntity anchor = (ContinuumAnchorBlockEntity)entity;
                ContinuumAnchorBlock.initializeArcanaBlock(stack, anchor);
                if (placer instanceof class_3222) {
                    class_3222 player = (class_3222)placer;
                    player.method_7353((class_2561)class_2561.method_43470((String)"Placing the Continuum Anchor sends a ripple across spacetime.").method_27692(class_124.field_1058), true);
                    SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_23115, (class_3419)class_3419.field_15245, (float)5.0f, (float)0.8f);
                }
            }
        }

        protected boolean method_9516(class_2680 state, class_10 type) {
            return false;
        }

        public static int getLightLevel(class_2680 state, int maxLevel) {
            return class_3532.method_15375((float)((float)((Integer)state.method_11654((class_2769)CHARGES)).intValue() / 4.0f * (float)maxLevel));
        }
    }

    public class ContinuumAnchorItem
    extends ArcanaPolymerBlockItem {
        public ContinuumAnchorItem(class_2248 block) {
            super(ContinuumAnchor.this.getThis(), block, ContinuumAnchor.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return ContinuumAnchor.this.prefItem;
        }
    }
}

