/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.IgneousColliderBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class IgneousCollider
extends ArcanaBlock {
    public static final String ID = "igneous_collider";
    public static final int COOLDOWN = 15;

    public IgneousCollider() {
        this.id = ID;
        this.name = "Igneous Collider";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS};
        this.vanillaItem = class_1802.field_23256;
        this.block = new IgneousColliderBlock(this, class_4970.class_2251.method_9637().method_29292().method_9629(3.5f, 1200.0f).method_9626(class_2498.field_23265));
        this.item = new IgneousColliderItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.igneous_collider", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1064});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_NETHERITE_PICKAXE, ResearchTasks.BREAK_OBSIDIAN, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN, ResearchTasks.ADVANCEMENT_ENCHANT_ITEM, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Mining ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"obsidian ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"is a pain, now this ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"device ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"can make it ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"automatically").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Place ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"lava ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"water ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"sources or cauldrons adjacent to the ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Collider").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Obsidian ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"will be ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"spat out").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" or into a ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"chest ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"above it ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"periodically").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"If a ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"netherite block").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" is below the ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Collider").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"crying obsidian").method_54663(0x660066)).method_10852((class_2561)class_2561.method_43470((String)" will be made.").method_27692(class_124.field_1076)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 12);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8354, 32);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8638, 24);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8178, 32);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_22024, 1, true).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9131), 5), new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9119), 3));
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, a, b, a}, {b, g, h, i, b}, {a, l, m, l, a}, {b, g, h, i, b}, {a, b, a, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Igneous Collider").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nMining Obsidian sucks. It's time intensive and mindlessly boring. Making a contraption to do it for me would be of great benefit. Some ductwork and enchanted pickaxes should work nicely.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Igneous Collider").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nThe Igneous Collider takes water and lava from either a source block or a cauldron that is adjacent to its side and spits out an Obsidian above it every minute. A Netherite block below the Collider produces Crying Obsidian.").method_27692(class_124.field_1074)));
        return list;
    }

    public class IgneousColliderBlock
    extends ArcanaPolymerBlockEntity {
        public IgneousColliderBlock(IgneousCollider this$0, class_4970.class_2251 settings) {
            super(this$0.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_23261.method_9564();
        }

        @Nullable
        public static IgneousColliderBlockEntity getEntity(class_1937 world, class_2338 pos) {
            IgneousColliderBlockEntity collider;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof IgneousColliderBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof IgneousColliderBlockEntity ? (collider = (IgneousColliderBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new IgneousColliderBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return IgneousColliderBlock.method_31618(type, ArcanaRegistry.IGNEOUS_COLLIDER_BLOCK_ENTITY, IgneousColliderBlockEntity::ticker);
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof IgneousColliderBlockEntity) {
                IgneousColliderBlockEntity collider = (IgneousColliderBlockEntity)entity;
                IgneousColliderBlock.initializeArcanaBlock(stack, collider);
            }
        }
    }

    public class IgneousColliderItem
    extends ArcanaPolymerBlockItem {
        public IgneousColliderItem(class_2248 block) {
            super(IgneousCollider.this.getThis(), block, IgneousCollider.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return IgneousCollider.this.prefItem;
        }
    }
}

