/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.HashMap;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.SpawnerInfuser;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.gui.spawnerinfuser.SpawnerInfuserGui;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class SpawnerInfuserBlockEntity
extends class_2621
implements class_1278,
PolymerObject,
class_1265,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private class_1277 inventory = new class_1277(this.method_5439());
    private boolean active;
    private class_1799 soulstone;
    private int points;
    private int spentPoints;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnRange;
    private short spawnCount;
    private short playerRange;
    private short maxEntities;
    private boolean updating;
    private boolean prevStone;
    private final HashMap<class_3222, SpawnerInfuserGui> watchingPlayers = new HashMap();

    public SpawnerInfuserBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ArcanaRegistry.SPAWNER_INFUSER_BLOCK_ENTITY, blockPos, blockState);
        this.inventory.method_5489((class_1265)this);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
        this.active = false;
        this.soulstone = class_1799.field_8037;
        this.points = 0;
        this.spentPoints = 0;
        this.minSpawnDelay = (short)200;
        this.maxSpawnDelay = (short)800;
        this.spawnCount = (short)4;
        this.maxEntities = (short)6;
        this.playerRange = (short)16;
        this.spawnRange = (short)4;
    }

    public void openGui(class_3222 player) {
        SpawnerInfuserGui gui = new SpawnerInfuserGui(player, this, this.method_10997());
        gui.build();
        gui.open();
        this.watchingPlayers.put(player, gui);
    }

    public void removePlayer(class_3222 player) {
        this.watchingPlayers.remove(player);
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof SpawnerInfuserBlockEntity) {
            SpawnerInfuserBlockEntity infuser = (SpawnerInfuserBlockEntity)e;
            infuser.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_8503().method_3780() % 5 == 0) {
            boolean hasSpawner;
            boolean prevActive = this.active;
            boolean hasRedstone = serverWorld.method_49803(this.field_11867);
            boolean hasSoulstone = !this.soulstone.method_7960();
            class_2338 spawnerPos = this.field_11867.method_10069(0, 2, 0);
            class_2586 blockEntity = serverWorld.method_8321(spawnerPos);
            class_2680 spawnerState = serverWorld.method_8320(spawnerPos);
            boolean bl = hasSpawner = spawnerState.method_27852(class_2246.field_10260) && blockEntity instanceof class_2636;
            if (!(hasRedstone && hasSoulstone && hasSpawner)) {
                if (prevActive) {
                    this.active = false;
                }
                this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SpawnerInfuser.SpawnerInfuserBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
                return;
            }
            String stoneType = Soulstone.getType(this.soulstone);
            class_2636 spawnerEntity = (class_2636)blockEntity;
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), LogUtils.getLogger());){
                class_11362 nbtWriteView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_10997().method_30349());
                spawnerEntity.method_11390().method_8272((class_11372)nbtWriteView);
                class_2487 spawnerData = nbtWriteView.method_71475();
                class_2487 spawnData = spawnerData.method_68568("SpawnData");
                if (spawnData.method_33133() || !spawnData.method_10545("entity") || !spawnData.method_68568("entity").method_10545("id")) {
                    if (prevActive) {
                        this.active = false;
                    }
                    this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SpawnerInfuser.SpawnerInfuserBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
                    return;
                }
                class_2487 spawnEntity = spawnData.method_68568("entity");
                boolean correctType = stoneType.equals(spawnEntity.method_68564("id", ""));
                if (correctType) {
                    if (!prevActive) {
                        this.active = true;
                    }
                    this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SpawnerInfuser.SpawnerInfuserBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
                    ArcanaEffectUtils.spawnerInfuser(serverWorld, this.field_11867, 5);
                    SoundUtils.soulSounds((class_3218)serverWorld, (class_2338)this.field_11867, (int)1, (int)5);
                }
            }
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.active) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    public void tickInfuser(class_2338 spawnerPos, class_2636 spawnerEntity) {
        class_1917 logic = spawnerEntity.method_11390();
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), LogUtils.getLogger());){
            class_11362 nbtWriteView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_10997().method_30349());
            logic.method_8272((class_11372)nbtWriteView);
            class_2487 savedLogic = nbtWriteView.method_71475();
            class_2487 newLogic = this.getSpawnerStats().method_10553();
            newLogic.method_10566("SpawnData", savedLogic.method_10580("SpawnData").method_10707());
            newLogic.method_10566("SpawnPotentials", savedLogic.method_10580("SpawnPotentials").method_10707());
            short oldDelay = savedLogic.method_68565("Delay", (short)0);
            short maxDelay = newLogic.method_68565("MaxSpawnDelay", (short)0);
            newLogic.method_10575("Delay", (short)Math.min(oldDelay, maxDelay));
            class_11368 newNbtReadView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.method_10997().method_30349(), (class_2487)newLogic);
            logic.method_8280(this.field_11863, spawnerPos, newNbtReadView);
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                logic.method_31588(serverWorld, spawnerPos);
            }
            class_11362 nbtWriteView2 = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_10997().method_30349());
            logic.method_8272((class_11372)nbtWriteView2);
            short newDelay = nbtWriteView2.method_71475().method_68565("Delay", (short)0);
            savedLogic.method_10575("Delay", newDelay);
            class_11368 savedNbtReadView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.method_10997().method_30349(), (class_2487)savedLogic);
            logic.method_8280(this.field_11863, spawnerPos, savedNbtReadView);
        }
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.SPAWNER_INFUSER;
    }

    public boolean isActive() {
        return this.active;
    }

    public class_1799 getSoulstone() {
        return this.soulstone;
    }

    public int getPoints() {
        return this.points;
    }

    public int getSpentPoints() {
        return this.spentPoints;
    }

    public void setSoulstone(class_1799 soulstone) {
        this.soulstone = soulstone;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setSpentPoints(int spentPoints) {
        this.spentPoints = spentPoints;
    }

    public void resetStats() {
        this.minSpawnDelay = (short)200;
        this.maxSpawnDelay = (short)800;
        this.spawnCount = (short)4;
        this.maxEntities = (short)6;
        this.playerRange = (short)16;
        this.spawnRange = (short)4;
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_2371 drops = class_2371.method_10211();
        int ratio = (int)Math.pow(2.0, 3 + ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.AUGMENTED_APPARATUS.id));
        int points = this.getPoints();
        if (points > 0) {
            class_1799 dropItem;
            while (points / ratio > 64) {
                dropItem = new class_1799((class_1935)SpawnerInfuser.POINTS_ITEM);
                dropItem.method_7939(64);
                drops.add((Object)dropItem.method_7972());
                points -= 64 * ratio;
            }
            dropItem = new class_1799((class_1935)SpawnerInfuser.POINTS_ITEM);
            dropItem.method_7939(points / ratio);
            drops.add((Object)dropItem.method_7972());
        }
        class_1264.method_17349((class_1937)this.field_11863, (class_2338)pos, (class_2371)drops);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.active = view.method_71433("active", false);
        this.points = view.method_71424("points", 0);
        this.spentPoints = view.method_71424("spentPoints", 0);
        this.soulstone = class_1799.field_8037;
        view.method_71426("soulstone", class_1799.field_24671).ifPresent(stack -> {
            this.soulstone = stack;
        });
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
        this.inventory = new class_1277(this.method_5439());
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, (class_2371)this.inventory.method_54454());
        }
        view.method_71426("spawnerStats", SpawnerStats.CODEC).ifPresent(stats -> this.setSpawnerStats(stats.toNbt()));
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
        view.method_71465("points", this.points);
        view.method_71465("spentPoints", this.spentPoints);
        view.method_71472("active", this.active);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, (class_2371)this.inventory.method_54454());
        }
        if (this.soulstone != null && !this.soulstone.method_7960()) {
            view.method_71477("soulstone", class_1799.field_24671, (Object)this.soulstone);
        }
        view.method_71477("spawnerStats", SpawnerStats.CODEC, (Object)SpawnerStats.fromNbt(this.getSpawnerStats()));
    }

    public class_2487 getSpawnerStats() {
        class_2487 stats = new class_2487();
        stats.method_10575("MinSpawnDelay", this.minSpawnDelay);
        stats.method_10575("MaxSpawnDelay", this.maxSpawnDelay);
        stats.method_10575("SpawnCount", this.spawnCount);
        stats.method_10575("MaxNearbyEntities", this.maxEntities);
        stats.method_10575("RequiredPlayerRange", this.playerRange);
        stats.method_10575("SpawnRange", this.spawnRange);
        return stats;
    }

    public void setSpawnerStats(class_2487 stats) {
        if (stats.method_10545("MinSpawnDelay")) {
            this.minSpawnDelay = stats.method_68565("MinSpawnDelay", (short)0);
        }
        if (stats.method_10545("MaxSpawnDelay")) {
            this.maxSpawnDelay = stats.method_68565("MaxSpawnDelay", (short)0);
        }
        if (stats.method_10545("SpawnCount")) {
            this.spawnCount = stats.method_68565("SpawnCount", (short)0);
        }
        if (stats.method_10545("MaxNearbyEntities")) {
            this.maxEntities = stats.method_68565("MaxNearbyEntities", (short)0);
        }
        if (stats.method_10545("RequiredPlayerRange")) {
            this.playerRange = stats.method_68565("RequiredPlayerRange", (short)0);
        }
        if (stats.method_10545("SpawnRange")) {
            this.spawnRange = stats.method_68565("SpawnRange", (short)0);
        }
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory.method_54454();
    }

    protected void method_11281(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Spawner Infuser");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 2;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public void refreshGuis() {
        this.watchingPlayers.values().forEach(SpawnerInfuserGui::build);
    }

    public void method_5453(class_1263 inv) {
        if (!this.updating) {
            this.updating = true;
            class_1799 soulstoneSlot = inv.method_5438(0);
            class_1799 extraPoints = class_1799.field_8037;
            int points = this.getPoints();
            int bonusCap = (new int[]{0, 64, 128, 192, 256, 352})[ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.SOUL_RESERVOIR.id)];
            int ratio = (int)Math.pow(2.0, 3 + ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.AUGMENTED_APPARATUS.id));
            if (!soulstoneSlot.method_7960()) {
                class_1799 pointsSlot;
                this.setSoulstone(soulstoneSlot);
                if (!this.prevStone) {
                    this.watchingPlayers.keySet().forEach(player -> SoundUtils.soulSounds((class_3222)player, (int)1, (int)20));
                    if (Soulstone.soulsToTier(Soulstone.getSouls(soulstoneSlot)) == Soulstone.tiers.length) {
                        this.watchingPlayers.keySet().forEach(player -> ArcanaAchievements.grant(player, ArcanaAchievements.INNOCENT_SOULS.id));
                    }
                }
                if (!(pointsSlot = inv.method_5438(1)).method_7960()) {
                    int toAdd;
                    int maxPoints = SpawnerInfuser.pointsFromTier[Soulstone.soulsToTier(Soulstone.getSouls(soulstoneSlot))] + bonusCap;
                    if (maxPoints - points < (toAdd = pointsSlot.method_7947() * ratio)) {
                        this.setPoints(maxPoints);
                        extraPoints = pointsSlot.method_7972();
                        extraPoints.method_7939((toAdd - (maxPoints - points)) / ratio);
                    } else {
                        this.setPoints(points + toAdd);
                    }
                    int curPoints = this.getPoints();
                    if (toAdd != 0 && points < maxPoints) {
                        this.watchingPlayers.keySet().forEach(player -> {
                            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23116, (float)1.0f, (float)(0.8f + (float)curPoints / (float)maxPoints));
                            if (curPoints == maxPoints) {
                                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23118, (float)1.0f, (float)2.0f);
                            }
                            if (curPoints >= 512) {
                                ArcanaAchievements.grant(player, ArcanaAchievements.ARCHLICH.id);
                            }
                            if (curPoints >= 1024) {
                                ArcanaAchievements.grant(player, ArcanaAchievements.POWER_OVERWHELMING.id);
                            }
                        });
                    }
                }
                this.prevStone = true;
            } else {
                this.setSoulstone(class_1799.field_8037);
                class_2371 drops = class_2371.method_10211();
                if ((points += inv.method_5438(1).method_7947() * ratio) > 0) {
                    class_1799 dropItem;
                    while (points / ratio > 64) {
                        dropItem = new class_1799((class_1935)SpawnerInfuser.POINTS_ITEM);
                        dropItem.method_7939(64);
                        drops.add((Object)dropItem.method_7972());
                        points -= 64 * ratio;
                    }
                    dropItem = new class_1799((class_1935)SpawnerInfuser.POINTS_ITEM);
                    dropItem.method_7939(points / ratio);
                    drops.add((Object)dropItem.method_7972());
                }
                if (this.method_10997() != null) {
                    class_1264.method_17349((class_1937)this.method_10997(), (class_2338)this.method_11016().method_10084(), (class_2371)drops);
                }
                if (this.prevStone) {
                    this.watchingPlayers.keySet().forEach(player -> SoundUtils.playSongToPlayer((class_3222)player, (class_6880.class_6883)class_3417.field_23117, (float)1.0f, (float)0.8f));
                }
                this.setPoints(0);
                this.resetStats();
                this.setSpentPoints(0);
                this.prevStone = false;
            }
            inv.method_5447(1, extraPoints);
            this.method_5431();
            this.refreshGuis();
            this.updating = false;
        }
    }

    public record SpawnerStats(short minSpawnDelay, short maxSpawnDelay, short spawnCount, short maxNearbyEntities, short requiredPlayerRange, short spawnRange) {
        public static final Codec<SpawnerStats> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.SHORT.fieldOf("MinSpawnDelay").forGetter(s -> s.minSpawnDelay), (App)Codec.SHORT.fieldOf("MaxSpawnDelay").forGetter(s -> s.maxSpawnDelay), (App)Codec.SHORT.fieldOf("SpawnCount").forGetter(s -> s.spawnCount), (App)Codec.SHORT.fieldOf("MaxNearbyEntities").forGetter(s -> s.maxNearbyEntities), (App)Codec.SHORT.fieldOf("RequiredPlayerRange").forGetter(s -> s.requiredPlayerRange), (App)Codec.SHORT.fieldOf("SpawnRange").forGetter(s -> s.spawnRange)).apply((Applicative)i, SpawnerStats::new));

        public class_2487 toNbt() {
            class_2487 n = new class_2487();
            n.method_10575("MinSpawnDelay", this.minSpawnDelay);
            n.method_10575("MaxSpawnDelay", this.maxSpawnDelay);
            n.method_10575("SpawnCount", this.spawnCount);
            n.method_10575("MaxNearbyEntities", this.maxNearbyEntities);
            n.method_10575("RequiredPlayerRange", this.requiredPlayerRange);
            n.method_10575("SpawnRange", this.spawnRange);
            return n;
        }

        public static SpawnerStats fromNbt(class_2487 n) {
            return new SpawnerStats(n.method_68565("MinSpawnDelay", (short)0), n.method_68565("MaxSpawnDelay", (short)0), n.method_68565("SpawnCount", (short)0), n.method_68565("MaxNearbyEntities", (short)0), n.method_68565("RequiredPlayerRange", (short)0), n.method_68565("SpawnRange", (short)0));
        }
    }
}

