/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.altars.CelestialAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class CelestialAltar
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "celestial_altar";
    private Multiblock multiblock;

    public CelestialAltar() {
        this.id = ID;
        this.name = "Celestial Altar";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.ALTARS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_37541;
        this.block = new CelestialAltarBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16030).method_9629(0.3f, 1200.0f).method_9631(state -> 15).method_9626(class_2498.field_37636));
        this.item = new CelestialAltarItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.celestial_altar", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_STARDUST, ResearchTasks.OBTAIN_NETHER_STAR, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addAltarLore(lore);
        lore.add(class_2561.method_43470((String)"Celestial Altar:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1078}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"glistens ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"in the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"light ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"of the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Sun ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Moon").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"lets you change the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"time of day").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" and the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"phase").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" of the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Moon").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"requires a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Nether Star").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"activate").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-5, 0, -5);
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8305, 4);
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8494, 4);
        ArcanaIngredient r = new ArcanaIngredient(class_1802.field_8055, 4);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8801, 4);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient k = new ArcanaIngredient(ArcanaRegistry.STARDUST, 12);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_37541, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, b, d, d}, {b, g, b, d, d}, {k, l, m, l, k}, {p, p, r, g, r}, {p, p, r, r, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Celestial Altar").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nLeylines across the world have their influence extend into the space beyond the world. If I can provide a sufficient energy source to the structure, I should be able to accelerate the sun or moon!").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Celestial Altar").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nA Nether Star should be sufficient to let this altar change the time of day and the phase of the moon by accelerating the motion of the celestial bodies for a moment before the Star is depleted.").method_27692(class_124.field_1074)));
        return list;
    }

    public class CelestialAltarBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;
        public static final class_2746 ACTIVATABLE = class_2746.method_11825((String)"activatable");

        public CelestialAltarBlock(class_4970.class_2251 settings) {
            super(CelestialAltar.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_37574.method_9564();
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)((class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{HORIZONTAL_FACING, ACTIVATABLE});
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Nullable
        public static CelestialAltarBlockEntity getEntity(class_1937 world, class_2338 pos) {
            CelestialAltarBlockEntity altar;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof CelestialAltarBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof CelestialAltarBlockEntity ? (altar = (CelestialAltarBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new CelestialAltarBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return CelestialAltarBlock.method_31618(type, ArcanaRegistry.CELESTIAL_ALTAR_BLOCK_ENTITY, CelestialAltarBlockEntity::ticker);
        }

        protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            CelestialAltarBlockEntity altar = (CelestialAltarBlockEntity)world.method_8321(pos);
            if (altar != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (altar.isAssembled()) {
                    altar.openGui(player);
                    player.method_7357().method_62835(playerEntity.method_6047(), 1);
                    player.method_7357().method_62835(playerEntity.method_6079(), 1);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    CelestialAltar.this.multiblock.displayStructure(altar.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof CelestialAltarBlockEntity) {
                CelestialAltarBlockEntity altar = (CelestialAltarBlockEntity)entity;
                CelestialAltarBlock.initializeArcanaBlock(stack, altar);
            }
        }

        private void tryActivate(class_2680 state, class_1937 world, class_2338 pos) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof CelestialAltarBlockEntity) {
                class_3218 serverWorld;
                boolean paid;
                CelestialAltarBlockEntity altar = (CelestialAltarBlockEntity)entity;
                if (world instanceof class_3218 && (paid = MinecraftUtils.removeItemEntities((class_3218)(serverWorld = (class_3218)world), (class_238)new class_238(pos.method_10084()), itemStack -> itemStack.method_31574((class_1792)CelestialAltarBlockEntity.COST.method_15442()), (int)((Integer)CelestialAltarBlockEntity.COST.method_15441())))) {
                    altar.startStarChange(null);
                }
            }
        }

        protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
            boolean bl = world.method_49803(pos);
            boolean bl2 = state.method_28500((class_2769)ACTIVATABLE).orElse(false);
            if (bl && bl2) {
                this.tryActivate(state, world, pos);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public class CelestialAltarItem
    extends ArcanaPolymerBlockItem {
        public CelestialAltarItem(class_2248 block) {
            super(CelestialAltar.this.getThis(), block, CelestialAltar.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return CelestialAltar.this.prefItem;
        }
    }
}

