/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.Waystone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.WaystoneIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class StarpathAltar
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "starpath_altar";
    public static final String TARGETS_TAG = "targets";
    private Multiblock multiblock;

    public StarpathAltar() {
        this.id = ID;
        this.name = "Starpath Altar";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.ALTARS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_37525;
        this.block = new StarpathAltarBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16009).method_9629(3.0f, 1200.0f).method_9631(state -> 6).method_9626(class_2498.field_37643));
        this.item = new StarpathAltarItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.starpath_altar", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1068});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_STARDUST, ResearchTasks.USE_ENDER_EYE, ResearchTasks.USE_ENDER_PEARL, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN, ResearchTasks.UNLOCK_WAYSTONE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        StarpathAltar.putProperty(stack, TARGETS_TAG, (class_2520)new class_2499());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        int size;
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addAltarLore(lore);
        lore.add(class_2561.method_43470((String)"Starpath Altar:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1068}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"finds a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"path ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"through the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"stars ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"anywhere ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"in the world.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"All creatures").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" standing in the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"will be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"teleported").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"requires ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Eyes of Ender").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"activate").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        if (itemStack != null && (size = StarpathAltar.getListProperty(itemStack, TARGETS_TAG).size()) > 0) {
            lore.add(class_2561.method_43470((String)""));
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Targets Stored: ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)("" + size)).method_27692(class_124.field_1062)));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2499 targetsList = StarpathAltar.getListProperty(stack, TARGETS_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        StarpathAltar.putProperty(newStack, TARGETS_TAG, (class_2520)targetsList);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-5, 0, -5);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8449, 24);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient h = new ArcanaIngredient(ArcanaRegistry.STARDUST, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8137, 1);
        WaystoneIngredient o = new WaystoneIngredient(true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, h, o, h, b}, {c, o, m, o, c}, {b, h, o, h, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Starpath Altar").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe leylines flow like rivers through the world, yet they are almost indistinct and would be impossible to navigate. However, the stars above pull on them like the moon on the tide. By charting the stars, and using ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Starpath Altar").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nWaystones to mark them, I should be able to send teleportation energy through the leylines along a charted course to exactly where I want to go in the world. It should even be capable of taking a group of creatures").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Starpath Altar").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nall at once to the same destination!\n\nUnfortunately, an Eye of Ender only contains so much teleportation energy, so the farther I wish to travel, the more Eyes I need to provide to have ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Starpath Altar").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nenough energy to create a continuous pathway along the leylines.\n\nI can Sneak Use a Waystone to encode a location into the Altar, or enter one manually.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StarpathAltarBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2746 BLOOM = class_2741.field_37651;
        public static final class_2746 ACTIVATABLE = class_2746.method_11825((String)"activatable");

        public StarpathAltarBlock(class_4970.class_2251 settings) {
            super(StarpathAltar.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return (class_2680)class_2246.field_37570.method_9564().method_11657((class_2769)BLOOM, (Comparable)((Boolean)state.method_11654((class_2769)BLOOM)));
        }

        @Nullable
        public static StarpathAltarBlockEntity getEntity(class_1937 world, class_2338 pos) {
            StarpathAltarBlockEntity altar;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof StarpathAltarBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof StarpathAltarBlockEntity ? (altar = (StarpathAltarBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new StarpathAltarBlockEntity(pos, state);
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)BLOOM, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{BLOOM, ACTIVATABLE});
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return StarpathAltarBlock.method_31618(type, ArcanaRegistry.STARPATH_ALTAR_BLOCK_ENTITY, StarpathAltarBlockEntity::ticker);
        }

        protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)world.method_8321(pos);
            if (altar != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (altar.isAssembled()) {
                    altar.openGui(player);
                    player.method_7357().method_62835(playerEntity.method_6047(), 1);
                    player.method_7357().method_62835(playerEntity.method_6079(), 1);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    StarpathAltar.this.multiblock.displayStructure(altar.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StarpathAltarBlockEntity) {
                StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)entity;
                StarpathAltarBlock.initializeArcanaBlock(stack, altar);
                altar.readTargets(ArcanaItem.getListProperty(stack, StarpathAltar.TARGETS_TAG));
            }
        }

        private void tryActivate(class_2680 state, class_1937 world, class_2338 pos) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StarpathAltarBlockEntity) {
                StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)entity;
                if (world instanceof class_3218) {
                    boolean paid;
                    class_3218 serverWorld = (class_3218)world;
                    boolean stargate = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.STARGATE.id) > 0;
                    Optional waystone = serverWorld.method_8390(class_1542.class, new class_238(pos.method_10084()), e -> e.method_6983().method_31574(ArcanaRegistry.WAYSTONE.getItem()) && Waystone.getTarget(e.method_6983()) != null && (stargate || Waystone.getTarget(e.method_6983()).world().method_29177().equals((Object)world.method_27983().method_29177()))).stream().findAny();
                    if (waystone.isPresent()) {
                        Waystone.WaystoneTarget target = Waystone.getTarget(((class_1542)waystone.get()).method_6983());
                        altar.setTarget(new StarpathAltarBlockEntity.TargetEntry(ArcanaUtils.getFormattedDimName(target.world()).getString() + " " + class_2338.method_49638((class_2374)target.position()).method_23854(), target.world().method_29177().toString(), (int)target.position().method_10216(), (int)target.position().method_10214(), (int)target.position().method_10215()));
                    }
                    if (paid = MinecraftUtils.removeItemEntities((class_3218)serverWorld, (class_238)new class_238(pos.method_10084()), itemStack -> itemStack.method_31574(StarpathAltarBlockEntity.COST), (int)altar.calculateCost())) {
                        altar.startTeleport(null);
                    }
                }
            }
        }

        protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
            boolean bl = world.method_49803(pos);
            boolean bl2 = state.method_28500((class_2769)ACTIVATABLE).orElse(false);
            if (bl && bl2) {
                this.tryActivate(state, world, pos);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public class StarpathAltarItem
    extends ArcanaPolymerBlockItem {
        public StarpathAltarItem(class_2248 block) {
            super(StarpathAltar.this.getThis(), block, StarpathAltar.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return StarpathAltar.this.prefItem;
        }
    }
}

