/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltar;
import net.borisshoes.arcananovum.callbacks.XPLoginCallback;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.altars.StarpathAltarGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.LoginCallback;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class StarpathAltarBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    public static final class_1792 COST = class_1802.field_8449;
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private int cooldown;
    private TargetEntry target;
    private List<TargetEntry> savedTargets;
    private int activeTicks;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.STARPATH_ALTAR)).getMultiblock();
    private static final Codec<TargetEntry> ENTRY_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("name").forGetter(TargetEntry::name), (App)Codec.STRING.fieldOf("dimension").forGetter(TargetEntry::dimension), (App)Codec.INT.fieldOf("x").forGetter(TargetEntry::x), (App)Codec.INT.fieldOf("y").forGetter(TargetEntry::y), (App)Codec.INT.fieldOf("z").forGetter(TargetEntry::z)).apply((Applicative)i, TargetEntry::new));

    public StarpathAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.STARPATH_ALTAR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
        this.target = new TargetEntry("", "", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260());
        this.activeTicks = 0;
        this.savedTargets = new ArrayList<TargetEntry>();
        this.resetCooldown();
    }

    public List<TargetEntry> getSavedTargets() {
        return this.savedTargets;
    }

    public void openGui(class_3222 player) {
        if (this.isActive()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"You cannot access an active Altar").method_27692(class_124.field_1061));
            return;
        }
        StarpathAltarGui gui = new StarpathAltarGui(player, this);
        gui.build();
        gui.open();
    }

    private void teleport(@Nullable class_3222 player) {
        int i;
        ArrayList<Object> locations;
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_3218 destWorld = this.method_10997().method_8503().method_3847(this.getTargetDimension());
        if (!destWorld.method_27983().method_29177().equals((Object)this.method_10997().method_27983().method_29177()) && ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.STARGATE.id) < 1) {
            return;
        }
        class_238 teleportBox = new class_238(this.method_11016().method_10069(0, 2, 0)).method_1009(5.0, 2.0, 5.0);
        List targets = this.method_10997().method_8333(null, teleportBox, e -> e instanceof class_1309 || e.method_5864().method_20210(ArcanaRegistry.STARPATH_ALLOWED));
        int tries = 0;
        int range = 4;
        int height = 2;
        do {
            locations = SpawnPile.makeSpawnLocations(targets.size(), range, this.getTarget().method_10264() + height, destWorld, this.getTarget());
            ++range;
            height += 16;
        } while (locations.size() != targets.size() && ++tries < 5);
        if (locations.size() != targets.size()) {
            for (class_1297 target : targets) {
                if (!(target instanceof class_3222)) continue;
                class_3222 targetPlayer = (class_3222)target;
                targetPlayer.method_7353((class_2561)class_2561.method_43470((String)"The teleport goes awry, everyone is shunted uncontrollably!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
            }
            locations = new ArrayList();
            for (i = 0; i < targets.size(); ++i) {
                locations.add(this.getTarget());
            }
        }
        for (i = 0; i < targets.size(); ++i) {
            class_1321 tameable;
            class_1297 target;
            target = (class_1297)targets.get(i);
            class_2338 location = (class_2338)locations.get(i);
            target.method_5731(new class_5454(destWorld, location.method_46558(), class_243.field_1353, target.method_36454(), target.method_36455(), class_5454.field_52247));
            ArcanaEffectUtils.recallTeleport(destWorld, target.method_19538());
            if (target instanceof class_3222) {
                class_3222 p = (class_3222)target;
                if (Math.sqrt(this.method_11016().method_10262((class_2382)this.getTarget())) >= 100000.0) {
                    ArcanaAchievements.grant(p, ArcanaAchievements.FAR_FROM_HOME.id);
                }
            }
            if (player == null || (!(target instanceof class_1321) || !(tameable = (class_1321)target).method_6171((class_1309)player)) && (!(target instanceof class_3222) || target == player) || !targets.contains(player)) continue;
            ArcanaAchievements.grant(player, ArcanaAchievements.ADVENTURING_PARTY.id);
        }
        SoundUtils.playSound((class_1937)destWorld, (class_2338)this.getTarget(), (class_3414)class_3417.field_14716, (class_3419)class_3419.field_15245, (float)2.0f, (float)1.5f);
    }

    public boolean startTeleport(@Nullable class_3222 player) {
        class_1937 class_19372;
        if (this.getCooldown() > 0 || !((class_19372 = this.method_10997()) instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_3218 destWorld = this.method_10997().method_8503().method_3847(this.getTargetDimension());
        if (!destWorld.method_27983().method_29177().equals((Object)this.method_10997().method_27983().method_29177()) && ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.STARGATE.id) < 1) {
            return false;
        }
        this.setActiveTicks(500);
        this.resetCooldown();
        ArcanaEffectUtils.starpathAltarAnim(destWorld, this.method_11016().method_46558());
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(500, () -> {
            this.teleport(player);
            if (player == null && this.getCrafterId() != null) {
                BorisLib.addLoginCallback((LoginCallback)new XPLoginCallback(serverWorld.method_8503(), this.getCrafterId(), ArcanaConfig.getInt(ArcanaRegistry.IGNEOUS_COLLIDER_PRODUCE)));
            } else if (player != null) {
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.STARPATH_ALTAR_ACTIVATE));
            }
        }));
        return true;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof StarpathAltarBlockEntity) {
            StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)e;
            altar.tick();
        }
    }

    public int calculateCost() {
        class_2338.class_2339 origin = this.method_11016().method_25503();
        class_2338 target = this.target.getBlockCoords();
        int multiplier = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.ASTRAL_PATHFINDER.id);
        int blocksPerUnit = 64 * (1 << multiplier);
        int cost = Math.max(1, (int)(Math.sqrt(origin.method_10262((class_2382)target)) / (double)blocksPerUnit));
        if (!this.getTargetDimension().method_29177().equals((Object)this.method_10997().method_27983().method_29177())) {
            cost += cost + 16;
        }
        return cost;
    }

    @Override
    public boolean isAssembled() {
        return this.multiblock.matches(this.getMultiblockCheck());
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.STARPATH_ALTAR)).getCheckOffset()), null);
    }

    private void tick() {
        boolean shouldBeActivatable;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.isAssembled() && this.cooldown > 0) {
            --this.cooldown;
        }
        boolean isActive = this.isActive();
        for (class_2338 blockPos : class_2338.method_25996((class_2338)this.field_11867, (int)4, (int)0, (int)4)) {
            class_2680 state = this.field_11863.method_8320(blockPos);
            if (!state.method_27852(class_2246.field_37570) && !blockPos.equals((Object)this.field_11867) || (Boolean)state.method_11654((class_2769)class_2741.field_37651) == isActive) continue;
            this.field_11863.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_37651, (Comparable)Boolean.valueOf(isActive)), 3);
        }
        if (isActive) {
            --this.activeTicks;
        }
        this.method_5431();
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.isAssembled()) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE).orElse(false);
        boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
        if (activatable ^ shouldBeActivatable) {
            serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
        }
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public void setActiveTicks(int ticks) {
        this.activeTicks = ticks;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            boolean shouldBeActivatable;
            class_3218 serverWorld = (class_3218)class_19372;
            boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE).orElse(false);
            boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
            if (activatable ^ shouldBeActivatable) {
                serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
            }
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void resetCooldown() {
        this.cooldown = 36000 - ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.CONSTELLATION_DRIFT.id) * 6000;
    }

    public void setTarget(class_2338 pos) {
        this.target = new TargetEntry("", "", pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void setTarget(TargetEntry pos) {
        this.target = pos;
    }

    public class_2338 getTarget() {
        if (this.target == null) {
            this.target = new TargetEntry("", "", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260());
        }
        return this.target.getBlockCoords();
    }

    public class_5321<class_1937> getTargetDimension() {
        class_3218 fetchedWorld = this.method_10997().method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)this.target.dimension())));
        if (fetchedWorld == null) {
            return this.method_10997().method_27983();
        }
        return fetchedWorld.method_27983();
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.STARPATH_ALTAR;
    }

    public class_2499 writeTargets() {
        if (this.savedTargets != null) {
            class_2499 targetList = new class_2499();
            for (TargetEntry entry : this.savedTargets) {
                class_2487 target = new class_2487();
                target.method_10582("name", entry.name);
                target.method_10582("dimension", entry.dimension);
                target.method_10569("x", entry.x);
                target.method_10569("y", entry.y);
                target.method_10569("z", entry.z);
                targetList.add((Object)target);
            }
            return targetList;
        }
        return new class_2499();
    }

    public void readTargets(class_2499 targetList) {
        this.savedTargets = new ArrayList<TargetEntry>();
        for (class_2520 e : targetList) {
            class_2487 target = (class_2487)e;
            this.savedTargets.add(new TargetEntry(target.method_68564("name", ""), target.method_68564("dimension", ""), target.method_68083("x", 0), target.method_68083("y", 0), target.method_68083("z", 0)));
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.cooldown = view.method_71424("cooldown", 0);
        this.target = new TargetEntry("", "", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260());
        view.method_71426("target", ENTRY_CODEC).ifPresent(data -> {
            this.target = data;
        });
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
        view.method_71426("targets", ENTRY_CODEC.listOf()).ifPresent(targets -> {
            this.savedTargets = new ArrayList<TargetEntry>((Collection<TargetEntry>)targets);
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
        view.method_71465("cooldown", this.cooldown);
        view.method_71477("target", ENTRY_CODEC, (Object)this.target);
        view.method_71477("targets", ENTRY_CODEC.listOf(), this.savedTargets);
    }

    public record TargetEntry(String name, String dimension, int x, int y, int z) {
        public class_2338 getBlockCoords() {
            return new class_2338(this.x, this.y, this.z);
        }
    }
}

