/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.altars.StormcallerAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class StormcallerAltar
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "stormcaller_altar";
    private Multiblock multiblock;

    public StormcallerAltar() {
        this.id = ID;
        this.name = "Altar of the Stormcaller";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.ALTARS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_33506;
        this.block = new StormcallerAltarBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15987).method_9629(5.0f, 1200.0f).method_29292().method_9626(class_2498.field_11533));
        this.item = new StormcallerAltarItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.stormcaller_altar", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_LIGHTNING_ROD_WITH_VILLAGER_NO_FIRE, ResearchTasks.OBTAIN_HEART_OF_THE_SEA, ResearchTasks.OBTAIN_LIGHTNING_ROD, ResearchTasks.ADVANCEMENT_WAX_ON, ResearchTasks.ADVANCEMENT_WAX_OFF, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addAltarLore(lore);
        lore.add(class_2561.method_43470((String)"Stormcaller Altar:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"calls upon the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"clouds ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"shift ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"darken").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"can be used to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"change ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"weather ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"to any state.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"requires a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Diamond Block").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"activate").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-5, 0, -5);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_27051, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_27074, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8477, 6);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8207, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_47018, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_33506, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Altar of the\n    Stormcaller").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nIn order to influence the world, I need to tap into the leylines. I have devised a structure capable of such, with this at its heart. It should be able to cause changes in the  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Altar of the\n    Stormcaller").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\natmosphere so that I can dictate the weather. Thunder, Rain, or Shine at my command! However, in order to provide enough energy to the leylines, I need to use a Diamond Block as a catalyst.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StormcallerAltarBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2746 ACTIVATABLE = class_2746.method_11825((String)"activatable");

        public StormcallerAltarBlock(class_4970.class_2251 settings) {
            super(StormcallerAltar.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_33509.method_9564();
        }

        @Nullable
        public static StormcallerAltarBlockEntity getEntity(class_1937 world, class_2338 pos) {
            StormcallerAltarBlockEntity altar;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof StormcallerAltarBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof StormcallerAltarBlockEntity ? (altar = (StormcallerAltarBlockEntity)class_25862) : null;
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)this.method_9564().method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{ACTIVATABLE});
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new StormcallerAltarBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return StormcallerAltarBlock.method_31618(type, ArcanaRegistry.STORMCALLER_ALTAR_BLOCK_ENTITY, StormcallerAltarBlockEntity::ticker);
        }

        protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            StormcallerAltarBlockEntity altar = (StormcallerAltarBlockEntity)world.method_8321(pos);
            if (altar != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (altar.isAssembled()) {
                    altar.openGui(player);
                    player.method_7357().method_62835(playerEntity.method_6047(), 1);
                    player.method_7357().method_62835(playerEntity.method_6079(), 1);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    StormcallerAltar.this.multiblock.displayStructure(altar.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StormcallerAltarBlockEntity) {
                StormcallerAltarBlockEntity altar = (StormcallerAltarBlockEntity)entity;
                StormcallerAltarBlock.initializeArcanaBlock(stack, altar);
            }
        }

        private void tryActivate(class_2680 state, class_1937 world, class_2338 pos) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StormcallerAltarBlockEntity) {
                class_3218 serverWorld;
                boolean paid;
                StormcallerAltarBlockEntity altar = (StormcallerAltarBlockEntity)entity;
                if (world instanceof class_3218 && (paid = MinecraftUtils.removeItemEntities((class_3218)(serverWorld = (class_3218)world), (class_238)new class_238(pos.method_10084()), itemStack -> itemStack.method_31574((class_1792)StormcallerAltarBlockEntity.COST.method_15442()), (int)((Integer)StormcallerAltarBlockEntity.COST.method_15441())))) {
                    altar.startWeatherChange(null);
                }
            }
        }

        protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
            boolean bl = world.method_49803(pos);
            boolean bl2 = state.method_28500((class_2769)ACTIVATABLE).orElse(false);
            if (bl && bl2) {
                this.tryActivate(state, world, pos);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public class StormcallerAltarItem
    extends ArcanaPolymerBlockItem {
        public StormcallerAltarItem(class_2248 block) {
            super(StormcallerAltar.this.getThis(), block, StormcallerAltar.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return StormcallerAltar.this.prefItem;
        }
    }
}

