/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisCatalystTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisSkillTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisUnattuneTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.InfusionTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipes;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class TransmutationAltar
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "transmutation_altar";
    private Multiblock multiblock;

    public TransmutationAltar() {
        this.id = ID;
        this.name = "Transmutation Altar";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.ALTARS};
        this.vanillaItem = class_1802.field_8603;
        this.block = new TransmutationAltarBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15983).method_9629(5.0f, 1200.0f).method_29292().method_9626(class_2498.field_27197));
        this.item = new TransmutationAltarItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.transmutation_altar", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_TRADE, ResearchTasks.OBTAIN_AMETHYST_SHARD, ResearchTasks.OBTAIN_DIAMOND, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addAltarLore(lore);
        lore.add(class_2561.method_43470((String)"Transmutation Altar:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Altar").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" beckons to an ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"ancient entity").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"balance").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"trades").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Altar").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" can be called upon to").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" exchange ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"equivalent materials").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Every ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"barter").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" comes with its own ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"price.").method_27692(class_124.field_1078)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<TransmutationRecipe> getUnlockedRecipes(class_3222 player) {
        return TransmutationRecipes.TRANSMUTATION_RECIPES.stream().filter(recipe -> {
            InfusionTransmutationRecipe r;
            if (recipe instanceof InfusionTransmutationRecipe && ArcanaItemUtils.isArcane((r = (InfusionTransmutationRecipe)recipe).getOutput()) && !ArcanaNovum.data((class_1657)player).hasResearched(ArcanaItemUtils.identifyItem(r.getOutput()))) {
                return false;
            }
            if (recipe instanceof AequalisCatalystTransmutationRecipe && (!ArcanaNovum.data((class_1657)player).hasResearched(ArcanaRegistry.AEQUALIS_SCIENTIA) || ArcanaNovum.data((class_1657)player).getAugmentLevel(ArcanaAugments.EQUIVALENT_EXCHANGE.id) <= 0)) {
                return false;
            }
            if (recipe instanceof AequalisSkillTransmutationRecipe && !ArcanaNovum.data((class_1657)player).hasResearched(ArcanaRegistry.AEQUALIS_SCIENTIA)) {
                return false;
            }
            return !(recipe instanceof AequalisUnattuneTransmutationRecipe) || ArcanaNovum.data((class_1657)player).hasResearched(ArcanaRegistry.AEQUALIS_SCIENTIA) && ArcanaNovum.data((class_1657)player).getAugmentLevel(ArcanaAugments.IMPERMANENT_PERMUTATION.id) > 0;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-5, 0, -5);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_23843, 24);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_27064, 16);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_20402, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_27063, 24);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8477, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8603, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, d, d}, {a, g, h, g, d}, {c, h, m, h, c}, {d, g, h, g, a}, {d, d, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThrough my research into leylines, I have discovered the essence of a living entity entwined within the leylines of the Overworld. From what I can tell, the entity is old, very old, and most ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nlikely of divine nature.\nIt is both singular and plural, like raindrops that become an ocean.\nI believe I can construct an altar that taps into the energy of this entity that rides the leylines. I wonder what capabilities this ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nstructure could yield.\n\nThe Altar I have created seems to mutate items when I drop them in specific configurations. The mutations are mostly consistent and follow some rule of conservation, but ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nconsumes reagents in the process.\nI will catalog all of the mutations I can find and document them in my Tome.\n\nThe points of interest are that there are 5 placement locations for items: \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nA positive input, marked by quartz.\n\nA negative input marked by blackstone.\n\nTwo reagent inputs, marked by amethyst.\n\nAnd the Altar keystone itself seems  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nlike it can channel energy, however I  haven\u2019t found an Item that works yet.\nWhen activated, the Altar will charge up and perform the transmutation.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Transmutation\n        Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nA gentle voice can be heard with each activation. The entity reminds me of the fae creatures that Illagers keep.").method_27692(class_124.field_1074)));
        return list;
    }

    public class TransmutationAltarBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;
        public static final class_2746 ACTIVATABLE = class_2746.method_11825((String)"activatable");

        public TransmutationAltarBlock(class_4970.class_2251 settings) {
            super(TransmutationAltar.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_10201.method_9564();
        }

        @Nullable
        public static TransmutationAltarBlockEntity getEntity(class_1937 world, class_2338 pos) {
            TransmutationAltarBlockEntity altar;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof TransmutationAltarBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof TransmutationAltarBlockEntity ? (altar = (TransmutationAltarBlockEntity)class_25862) : null;
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)((class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{HORIZONTAL_FACING, ACTIVATABLE});
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new TransmutationAltarBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return TransmutationAltarBlock.method_31618(type, ArcanaRegistry.TRANSMUTATION_ALTAR_BLOCK_ENTITY, TransmutationAltarBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            TransmutationAltarBlockEntity altar = (TransmutationAltarBlockEntity)world.method_8321(pos);
            if (altar != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (altar.isAssembled()) {
                    altar.openGui(player);
                    player.method_7357().method_62835(playerEntity.method_6047(), 1);
                    player.method_7357().method_62835(playerEntity.method_6079(), 1);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    TransmutationAltar.this.multiblock.displayStructure(altar.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (placer instanceof class_3222) {
                class_3222 player = (class_3222)placer;
                if (entity instanceof TransmutationAltarBlockEntity) {
                    TransmutationAltarBlockEntity altar = (TransmutationAltarBlockEntity)entity;
                    TransmutationAltarBlock.initializeArcanaBlock(stack, altar);
                }
            }
        }

        private void tryActivate(class_2680 state, class_1937 world, class_2338 pos) {
            TransmutationAltarBlockEntity altar;
            boolean started;
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TransmutationAltarBlockEntity && !(started = (altar = (TransmutationAltarBlockEntity)entity).startTransmute(null))) {
                SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_38369, (class_3419)class_3419.field_15245, (float)0.5f, (float)0.7f);
            }
        }

        protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
            boolean bl = world.method_49803(pos);
            boolean bl2 = state.method_28500((class_2769)ACTIVATABLE).orElse(false);
            if (bl && bl2) {
                this.tryActivate(state, world, pos);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATABLE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public class TransmutationAltarItem
    extends ArcanaPolymerBlockItem {
        public TransmutationAltarItem(class_2248 block) {
            super(TransmutationAltar.this.getThis(), block, TransmutationAltar.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return TransmutationAltar.this.prefItem;
        }
    }
}

