/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.CelestialAltar;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltar;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.altars.TransmutationAltarGui;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipes;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class TransmutationAltarBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private int cooldown;
    private boolean active;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.TRANSMUTATION_ALTAR)).getMultiblock();

    public TransmutationAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.TRANSMUTATION_ALTAR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
        this.resetCooldown();
    }

    public void openGui(class_3222 player) {
        if (this.active) {
            player.method_64398((class_2561)class_2561.method_43470((String)"You cannot access an active Altar").method_27692(class_124.field_1061));
            return;
        }
        TransmutationAltarGui gui = new TransmutationAltarGui(class_3917.field_17337, player, this);
        gui.buildMenuGui();
        gui.open();
    }

    public boolean startTransmute(@Nullable class_3222 player) {
        class_1657 crafter;
        class_1937 class_19372;
        if (this.getCooldown() > 0 || this.checkTransmute() == null || !((class_19372 = this.method_10997()) instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.resetCooldown();
        boolean hastyBargain = ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.HASTY_BARGAIN.id) > 0;
        double speedMod = hastyBargain ? 2.0 : 1.0;
        int castTime = (int)(500.0 / speedMod);
        this.setActive(true);
        if (player == null && this.getCrafterId() != null && (crafter = serverWorld.method_18470(AlgoUtils.getUUID((String)this.getCrafterId()))) instanceof class_3222) {
            player = (class_3222)crafter;
        }
        class_3222 finalPlayer = player;
        ArcanaEffectUtils.transmutationAltarAnim(serverWorld, this.method_11016().method_46558(), 0.0, (class_2350)this.method_10997().method_8320(this.method_11016()).method_11654(CelestialAltar.CelestialAltarBlock.HORIZONTAL_FACING), speedMod);
        BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(castTime, () -> this.transmute(finalPlayer, false)));
        return true;
    }

    public TransmutationRecipe checkTransmute() {
        HashMap<String, class_1542> stacks = this.getTransmutingStacks();
        class_1542 positiveEntity = stacks.get("positive");
        class_1542 negativeEntity = stacks.get("negative");
        class_1542 reagent1Entity = stacks.get("reagent1");
        class_1542 reagent2Entity = stacks.get("reagent2");
        class_1542 aequalisEntity = stacks.get("aequalis");
        class_1799 positiveStack = positiveEntity == null ? class_1799.field_8037 : positiveEntity.method_6983();
        class_1799 negativeStack = negativeEntity == null ? class_1799.field_8037 : negativeEntity.method_6983();
        class_1799 reagent1Stack = reagent1Entity == null ? class_1799.field_8037 : reagent1Entity.method_6983();
        class_1799 reagent2Stack = reagent2Entity == null ? class_1799.field_8037 : reagent2Entity.method_6983();
        class_1799 aequalisStack = aequalisEntity == null ? class_1799.field_8037 : aequalisEntity.method_6983();
        return TransmutationRecipes.findMatchingRecipe(positiveStack, negativeStack, reagent1Stack, reagent2Stack, aequalisStack, this);
    }

    public void transmute(@Nullable class_3222 player, boolean recursed) {
        HashMap<String, class_1542> stacks = this.getTransmutingStacks();
        class_1542 positiveEntity = stacks.get("positive");
        class_1542 negativeEntity = stacks.get("negative");
        class_1542 reagent1Entity = stacks.get("reagent1");
        class_1542 reagent2Entity = stacks.get("reagent2");
        class_1542 aequalisEntity = stacks.get("aequalis");
        class_1799 positiveStack = positiveEntity == null ? class_1799.field_8037 : positiveEntity.method_6983();
        class_1799 negativeStack = negativeEntity == null ? class_1799.field_8037 : negativeEntity.method_6983();
        class_1799 reagent1Stack = reagent1Entity == null ? class_1799.field_8037 : reagent1Entity.method_6983();
        class_1799 reagent2Stack = reagent2Entity == null ? class_1799.field_8037 : reagent2Entity.method_6983();
        class_1799 aequalisStack = aequalisEntity == null ? class_1799.field_8037 : aequalisEntity.method_6983();
        TransmutationRecipe recipe = TransmutationRecipes.findMatchingRecipe(positiveStack, negativeStack, reagent1Stack, reagent2Stack, aequalisStack, this);
        this.setActive(false);
        if (recipe != null) {
            boolean canRecurse;
            class_1799 output;
            List<class_3545<class_1799, String>> outputs = recipe.doTransmutation(positiveEntity, negativeEntity, reagent1Entity, reagent2Entity, aequalisEntity, this, player);
            int transmuteCount = 0;
            for (class_3545<class_1799, String> outputPair : outputs) {
                output = (class_1799)outputPair.method_15442();
                class_243 outputPos = this.getOutputPos((String)outputPair.method_15441());
                transmuteCount += output.method_7947();
                if (output.method_31574(ArcanaRegistry.DIVINE_CATALYST.getItem()) && player != null) {
                    ArcanaNovum.data((class_1657)player).addCraftedSilent(output);
                    ArcanaAchievements.grant(player, ArcanaAchievements.DIVINE_TRANSMUTATION.id);
                }
                if (output.method_31574(ArcanaRegistry.AEQUALIS_SCIENTIA.getItem()) && player != null) {
                    ArcanaNovum.data((class_1657)player).addCraftedSilent(output);
                    ArcanaAchievements.grant(player, ArcanaAchievements.PRICE_OF_KNOWLEDGE.id);
                }
                this.method_10997().method_8649((class_1297)new class_1542(this.method_10997(), outputPos.field_1352, outputPos.field_1351 + 0.25, outputPos.field_1350, output, 0.0, 0.0, 0.0));
            }
            if (transmuteCount > 0 && player != null) {
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.TRANSMUTATION_ALTAR_TRANSMUTE_PER_ITEM) * transmuteCount + ArcanaConfig.getInt(ArcanaRegistry.TRANSMUTATION_ALTAR_TRANSMUTE));
                ArcanaAchievements.progress(player, ArcanaAchievements.STATE_ALCHEMIST.id, transmuteCount);
            }
            boolean bl = canRecurse = ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.TRADE_AGREEMENT.id) > 0;
            if (canRecurse && this.checkTransmute() == recipe && (output = this.method_10997()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)output;
                this.resetCooldown();
                boolean hastyBargain = ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.HASTY_BARGAIN.id) > 0;
                double speedMod = hastyBargain ? 2.0 : 1.0;
                int castTime = (int)(500.0 / speedMod);
                this.setActive(true);
                ArcanaEffectUtils.transmutationAltarAnim(serverWorld, this.method_11016().method_46558(), 0.0, (class_2350)this.method_10997().method_8320(this.method_11016()).method_11654(TransmutationAltar.TransmutationAltarBlock.HORIZONTAL_FACING), speedMod);
                BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(castTime, () -> this.transmute(player, true)));
            }
            SoundUtils.playSound((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_3414)class_3417.field_38365, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.8f);
            this.field_11863.method_43276((class_6880)class_5712.field_28174, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        } else {
            if (!recursed) {
                this.refundCooldown();
            }
            SoundUtils.playSound((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_3414)class_3417.field_38369, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.7f);
            this.field_11863.method_43276((class_6880)class_5712.field_28175, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        }
    }

    public HashMap<String, class_1542> getTransmutingStacks() {
        HashMap<String, class_1542> stacks = new HashMap<String, class_1542>();
        if (this.field_11863 == null || this.field_11867 == null) {
            return stacks;
        }
        class_2350 direction = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654(TransmutationAltar.TransmutationAltarBlock.HORIZONTAL_FACING);
        class_243 centerPos = this.method_11016().method_46558();
        class_243 aequalisPos = centerPos.method_1019(new class_243(0.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 negativePos = centerPos.method_1019(new class_243(3.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 positivePos = centerPos.method_1019(new class_243(-3.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 reagent1Pos = centerPos.method_1019(new class_243(0.0, 0.6, -3.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 reagent2Pos = centerPos.method_1019(new class_243(0.0, 0.6, 3.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_1542 aequalisEntity = MinecraftUtils.getLargestItemEntity((List)this.field_11863.method_18023((class_5575)class_1299.field_6052, new class_238(class_2338.method_49638((class_2374)aequalisPos)), e -> true));
        class_1542 positiveEntity = MinecraftUtils.getLargestItemEntity((List)this.field_11863.method_18023((class_5575)class_1299.field_6052, new class_238(class_2338.method_49638((class_2374)positivePos)), e -> true));
        class_1542 negativeEntity = MinecraftUtils.getLargestItemEntity((List)this.field_11863.method_18023((class_5575)class_1299.field_6052, new class_238(class_2338.method_49638((class_2374)negativePos)), e -> true));
        class_1542 reagent1Entity = MinecraftUtils.getLargestItemEntity((List)this.field_11863.method_18023((class_5575)class_1299.field_6052, new class_238(class_2338.method_49638((class_2374)reagent1Pos)), e -> true));
        class_1542 reagent2Entity = MinecraftUtils.getLargestItemEntity((List)this.field_11863.method_18023((class_5575)class_1299.field_6052, new class_238(class_2338.method_49638((class_2374)reagent2Pos)), e -> true));
        stacks.put("aequalis", aequalisEntity);
        stacks.put("positive", positiveEntity);
        stacks.put("negative", negativeEntity);
        stacks.put("reagent1", reagent1Entity);
        stacks.put("reagent2", reagent2Entity);
        return stacks;
    }

    public class_243 getOutputPos(String outputString) {
        if (this.field_11863 == null || this.field_11867 == null) {
            return null;
        }
        class_2350 direction = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654(TransmutationAltar.TransmutationAltarBlock.HORIZONTAL_FACING);
        class_243 centerPos = this.method_11016().method_46558();
        class_243 aequalisPos = centerPos.method_1019(new class_243(0.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 negativePos = centerPos.method_1019(new class_243(3.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 positivePos = centerPos.method_1019(new class_243(-3.0, 0.6, 0.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 reagent1Pos = centerPos.method_1019(new class_243(0.0, 0.6, -3.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        class_243 reagent2Pos = centerPos.method_1019(new class_243(0.0, 0.6, 3.0).method_1024((float)(-((double)direction.method_10161() * 1.5707963267948966))));
        if (outputString.equals("positive")) {
            return positivePos;
        }
        if (outputString.equals("negative")) {
            return negativePos;
        }
        if (outputString.equals("reagent1")) {
            return reagent1Pos;
        }
        if (outputString.equals("reagent2")) {
            return reagent2Pos;
        }
        return aequalisPos;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof TransmutationAltarBlockEntity) {
            TransmutationAltarBlockEntity altar = (TransmutationAltarBlockEntity)e;
            altar.tick();
        }
    }

    @Override
    public boolean isAssembled() {
        return this.multiblock.matches(this.getMultiblockCheck());
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.TRANSMUTATION_ALTAR)).getCheckOffset()), (class_2350)this.field_11863.method_8320(this.field_11867).method_11654(TransmutationAltar.TransmutationAltarBlock.HORIZONTAL_FACING));
    }

    private void tick() {
        boolean shouldBeActivatable;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.isAssembled() && this.cooldown > 0) {
            --this.cooldown;
            this.method_5431();
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.isAssembled()) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)TransmutationAltar.TransmutationAltarBlock.ACTIVATABLE).orElse(false);
        boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
        if (activatable ^ shouldBeActivatable) {
            serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)TransmutationAltar.TransmutationAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            boolean shouldBeActivatable;
            class_3218 serverWorld = (class_3218)class_19372;
            boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)TransmutationAltar.TransmutationAltarBlock.ACTIVATABLE).orElse(false);
            boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
            if (activatable ^ shouldBeActivatable) {
                serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)TransmutationAltar.TransmutationAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
            }
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void resetCooldown() {
        this.cooldown = 13200 - ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.HASTY_BARGAIN.id) * 2400;
    }

    public void refundCooldown() {
        this.cooldown = 0;
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.TRANSMUTATION_ALTAR;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.cooldown = view.method_71424("cooldown", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
        view.method_71465("cooldown", this.cooldown);
    }
}

