/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.midnightenchanter.MidnightEnchanterGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class MidnightEnchanterBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.MIDNIGHT_ENCHANTER)).getMultiblock();
    private boolean assembled;
    private boolean seenForge;
    private boolean hasBooks;

    public MidnightEnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.MIDNIGHT_ENCHANTER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof MidnightEnchanterBlockEntity) {
            MidnightEnchanterBlockEntity enchanter = (MidnightEnchanterBlockEntity)e;
            enchanter.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int ticks = serverWorld.method_8503().method_3780();
        if (ticks % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
            this.seenForge = StarlightForge.findActiveForge(serverWorld, this.field_11867) != null;
            int bookshelfCount = 0;
            for (class_2338 blockPos : class_2338.method_10097((class_2338)this.field_11867.method_10069(-2, -2, -2), (class_2338)this.field_11867.method_10069(2, 2, 2))) {
                if (!this.field_11863.method_8320(blockPos).method_27852(class_2246.field_10504) && !this.field_11863.method_8320(blockPos).method_27852(class_2246.field_40276)) continue;
                ++bookshelfCount;
            }
            boolean bl = this.hasBooks = bookshelfCount >= 20;
        }
        if (this.assembled && this.seenForge && this.hasBooks) {
            ArcanaEffectUtils.midnightEnchanterAnim(serverWorld, this.field_11867.method_46558(), ticks % 300);
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled && this.seenForge) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    public void openGui(class_3222 player) {
        MidnightEnchanterGui gui = new MidnightEnchanterGui(player, this);
        gui.buildGui();
        gui.open();
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public boolean hasBooks() {
        return this.hasBooks;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.MIDNIGHT_ENCHANTER)).getCheckOffset()), null);
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.MIDNIGHT_ENCHANTER;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
    }
}

