/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.radiantfletchery.RadiantFletcheryGui;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class RadiantFletcheryBlockEntity
extends class_2621
implements class_1278,
PolymerObject,
class_1265,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private final Multiblock multiblock;
    private boolean assembled;
    private boolean seenForge;
    private boolean updating;
    private class_1277 inventory = new class_1277(this.method_5439());
    private final int[] efficiency = new int[]{24, 32, 40, 48, 56, 64};
    private final Set<class_3222> watchingPlayers = new HashSet<class_3222>();

    public RadiantFletcheryBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.RADIANT_FLETCHERY_BLOCK_ENTITY, pos, state);
        this.multiblock = ((MultiblockCore)((Object)ArcanaRegistry.RADIANT_FLETCHERY)).getMultiblock();
        this.inventory.method_5489((class_1265)this);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof RadiantFletcheryBlockEntity) {
            RadiantFletcheryBlockEntity fletchery = (RadiantFletcheryBlockEntity)e;
            fletchery.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_8503().method_3780() % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
            boolean bl = this.seenForge = StarlightForge.findActiveForge(serverWorld, this.field_11867) != null;
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled && this.seenForge) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        this.watchingPlayers.removeIf(player -> player.field_7512 == player.field_7498);
    }

    public int getPotionRatio() {
        int lvl = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.ALCHEMICAL_EFFICIENCY.id);
        return this.efficiency[lvl];
    }

    public void openGui(class_3222 player) {
        RadiantFletcheryGui gui = new RadiantFletcheryGui(player, this);
        gui.buildGui();
        gui.open();
        this.watchingPlayers.add(player);
    }

    public void removePlayer(class_3222 player) {
        this.watchingPlayers.remove(player);
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.RADIANT_FLETCHERY)).getCheckOffset()), null);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.RADIANT_FLETCHERY;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.inventory = new class_1277(this.method_5439());
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, (class_2371)this.inventory.method_54454());
        }
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, (class_2371)this.inventory.method_54454());
        }
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory.method_54454();
    }

    protected void method_11281(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Radiant Fletchery");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 3;
    }

    public void method_5453(class_1263 inv) {
        if (!this.updating) {
            this.updating = true;
            class_1799 arrowStack = inv.method_5438(0);
            class_1799 potionStack = inv.method_5438(1);
            class_1799 outputStack = inv.method_5438(2);
            int potionRatio = this.getPotionRatio();
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8087);
            resultStack.method_57379(class_9334.field_49651, (Object)((class_1844)potionStack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)));
            resultStack.method_7939(potionRatio);
            while (arrowStack.method_7947() >= potionRatio && potionStack.method_7947() >= 1 && (outputStack.method_7914() - outputStack.method_7947() >= potionRatio && class_1799.method_31577((class_1799)outputStack, (class_1799)resultStack) || outputStack.method_7960())) {
                arrowStack.method_7934(potionRatio);
                inv.method_5447(0, arrowStack.method_7960() ? class_1799.field_8037 : arrowStack);
                potionStack.method_7934(1);
                inv.method_5447(1, potionStack.method_7960() ? class_1799.field_8037 : potionStack);
                if (outputStack.method_7960()) {
                    outputStack = resultStack;
                    inv.method_5447(2, resultStack);
                } else {
                    outputStack.method_7933(potionRatio);
                    inv.method_5447(2, outputStack);
                }
                this.watchingPlayers.forEach(player -> ArcanaAchievements.grant(player, ArcanaAchievements.FINALLY_USEFUL_2.id));
                this.watchingPlayers.forEach(player -> ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.RADIANT_FLETCHERY_TIP_ARROWS)));
            }
            this.method_5431();
            this.updating = false;
        }
    }
}

